//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi;

/** <!-- ========================================================================================================== -->
* This class provides log functionality for the SDK.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class Log
{
	protected static final boolean DEBUG = true;

	/** Constant used to indent output. */
	private static final String[] INDENT = {"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t"};

	private static final Log LOGGER = new Log();

	private boolean	itsDebug = DEBUG;

	/** <!-- ================================================================================================== -->
	* Retrive the singleton logger.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public static Log getInstance()
	{
		return LOGGER;
	}

	/** <!-- ================================================================================================== -->
	* Is debug logging turned on.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public boolean debugOn()
	{
		return itsDebug;
	}

	/** <!-- ================================================================================================== -->
	* Turn on/off debug logging.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public void setDebug(boolean val)
	{
		itsDebug = val;
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public void debug(String msg)
	{
		debug(0, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public void debug(int indent, String msg)
	{
		if (debugOn())
			writeLog(INDENT[indent] + msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public void info(String msg)
	{
		info(0, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public void info(int indent, String msg)
	{
		writeLog(INDENT[indent] + msg);
	}

	/** <!-- ================================================================================================== -->
	* Write the message to the log
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void writeLog(String msg)
	{
		System.out.println(msg);
	}
}
