//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapstation.db.Application;
import com.actional.soapapi.soapstation.ApplicationTask;

/** <!-- ========================================================================================================== -->
* Set the default {@link com.actional.soapstation.db.Application} for use when creating a
* {@link com.actional.soapstation.db.SvcGroup}.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class DefaultApplicationTask extends RefTaskBase
{
	@Override
	protected Class _getRefType()	{ return Application.class; }

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	public void executeEx() throws Exception
	{
		ApplicationTask	appTask = (ApplicationTask)createTask(ApplicationTask.class);
		Application	app = (Application)locateBaseData();
		
		appTask.setDefaultApplication(app);
	}
}
