//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapstation.db.Application;
import com.actional.soapstation.db.EndpointPrefix;
import com.actional.soapstation.db.ApplicationSecurityContract;
import com.actional.soapapi.anttask.IBaseDataKeyID;
import com.actional.soapapi.anttask.BaseDataType;
import com.actional.soapapi.Util;
import java.util.Vector;
import org.apache.tools.ant.types.Reference;

/** <!-- ========================================================================================================== -->
* Create a new {@link com.actional.soapstation.db.Application}.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class CreateApplicationTask extends SOAPstationTaskBase implements IBaseDataKeyID
{
	/** Keep track of the Application ID that we created in case we need it. */
	private String itsApplicationID;

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected Application	itsApplication = new Application();
	protected Reference	itsSecContract;
	protected HeartBeatType	itsHeartBeat;
	protected Vector	itsEndpoints;

	public void setName(String val)			{ itsApplication.setKeyName(val); }
	public void setDescription(String val)		{ itsApplication.setDescription(val); }
	public void setSecContract(Reference val)	{ itsSecContract = val; }

	public void addConfiguredHeartBeat(HeartBeatType val)		{ itsHeartBeat = val; }
	public void addConfiguredEndpointPrefix(EndpointPrefixType val)
	{
		if (val == null)
			return;

		EndpointPrefix endpoint = val._getEndpointPrefix(false);

		if (endpoint == null)
			return;

		if (itsEndpoints == null)
			itsEndpoints = new Vector();

		itsEndpoints.add(endpoint);
	}

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	public void executeEx() throws Exception
	{
		ApplicationSecurityContract secContract = (ApplicationSecurityContract)locateBaseData(itsSecContract);

		itsApplication.setSecurityContract(secContract);

		if (itsHeartBeat != null)
		{
			itsHeartBeat.execute(_getSSTConfig());
			itsApplication.setHeartBeat(itsHeartBeat._getHeartBeat(false));
		}

		if (!Util.isBlank(itsEndpoints))
		{
			EndpointPrefix[] endpoints = new EndpointPrefix[itsEndpoints.size()];
			itsEndpoints.toArray(endpoints);
			itsApplication.setEndpointPrefixes(endpoints);
		}

		itsApplicationID = _getSSTConfig().appTask.createApplication(itsApplication);

		log("Created Application '" + itsApplication.getKeyName() + "' KeyID: " + getKeyID());
	}

	/** <!-- ================================================================================================== -->
	* IBaseDataKeyID interface
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public String getKeyID()
	{
		return itsApplicationID;
	}
}

