//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================


package com.actional.soapapi.jetty;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.rpc.ServiceException;

import com.actional.jetty.task.IListenersTask;
import com.actional.jetty.task.IListenersTaskServiceLocator;
import com.actional.jetty.task.ISettingsTask;
import com.actional.jetty.task.ISettingsTaskServiceLocator;
import com.actional.soapapi.Config;

/** <!-- ========================================================================================================== -->
* This class provides typical services exposed by Actional Jetty App Server.
* 
* @lastrev fix41984 - Add Jetty settings task
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class JettyConfig extends Config
{

	/** <!-- ================================================================================================== -->
	* The Locators for the task services
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected IListenersTaskServiceLocator	listenersTaskLocator = new IListenersTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ISettingsTaskServiceLocator	settingsTaskLocator = new ISettingsTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	/** <!-- ================================================================================================== -->
	* The Tasks
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	private IListenersTask	listenersTask;
	private ISettingsTask	settingsTask;

	protected static JettyConfig itsDefaultConfig;

	public static synchronized JettyConfig getDefaultConfig()
	{
		return itsDefaultConfig;
	}

	public static synchronized void	setDefaultConfig(JettyConfig config)
	{
		itsDefaultConfig = config;
	}

	public static synchronized boolean setDefaultConfigIfNotSet(JettyConfig config)
	{
		if (itsDefaultConfig == null)
		{
			itsDefaultConfig = config;
			return true;
		}
		else
			return false;
	}
	
	public IListenersTask getListenersTask()
	{
		return listenersTask;
	}

	public ISettingsTask getSettingsTask()
	{
		return settingsTask;
	}

	/** <!-- ================================================================================================== -->
	 * Constructor
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	public JettyConfig()
	{
		// Use the default configuration.
		super(null, null, null);
	}

	public JettyConfig(String userName, String password, String endpoint)
	{
		super(userName, password, endpoint);
	}

	/** <!-- ================================================================================================== -->
	* Initialize the axis stubs.
	* 
	* @lastrev fix41984 - Add Jetty settings task
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	protected void prepareTasks()
		throws ServiceException, MalformedURLException
	{
		super.prepareTasks();

		listenersTask = listenersTaskLocator.getIListenersTask(
						proxyUrl(listenersTaskLocator.getIListenersTaskAddress()));
		prepareStub(listenersTask);

		settingsTask = settingsTaskLocator.getISettingsTask(
						proxyUrl(settingsTaskLocator.getISettingsTaskAddress()));

		prepareStub(settingsTask);
	}

	/** <!-- ================================================================================================== -->
	* Prepare the task in the SDK. These are tasks on the client side to simplify server operations.
	*
	* @param taskClass	Subclass of ServerTask
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public synchronized JettyTask createTask(Class taskClass) throws Exception
	{
		JettyTask task = (JettyTask)itsTaskCache.get(taskClass);

		if (task != null)
			return task;

		try
		{
			task = (JettyTask)taskClass.newInstance();
			task.setConfig(this);
			itsTaskCache.put(taskClass, task);

			return task;
		}
		catch (Exception e)
		{
			throw new Exception("Failed to instanciate class: " + taskClass.getName(), e);
		}
	}

	protected Map itsTaskCache = new HashMap();

}
