//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapapi.soapstation.DeploymentTask;
import com.actional.soapapi.Util;
import com.actional.soapstation.task.ImportDef;
import org.apache.tools.ant.types.FileSet;
import java.io.File;

/** <!-- ========================================================================================================== -->
* Import one or more deployment files.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class ImportConfigTask extends SOAPstationTaskBase
{
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected ImportDef	itsImportInfo = new ImportDef();
	protected FileSet	itsFiles;
	
	public void setActivateRevisions(boolean val)	{ itsImportInfo.setActivateRevisions(val); }
	public void setPerformImport(boolean val)	{ itsImportInfo.setPerformImport(val); }
	public void setRepublishToUddi(boolean val)	{ itsImportInfo.setRepublishToUddi(val); }
	public void setBackupFileName(String val)	{ itsImportInfo.setBackupFileName(val); }
	public void addFileSet(FileSet val)		{ itsFiles = val; }
	
	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	public void executeEx() throws Exception
	{
		File 	 baseDir = null;
		String[] files = null;

		if (itsFiles != null)
		{
			baseDir = itsFiles.getDir(getProject());
			files = itsFiles.getDirectoryScanner(getProject()).getIncludedFiles();
		}

		if (Util.isBlank(files))
		{
			log("No files specified for import.");
			return;
		}

		DeploymentTask deployTask = (DeploymentTask)createTask(DeploymentTask.class);

		log("Imported: " + deployTask.importCustom(itsImportInfo, files, baseDir));
	}
}
