/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElement
implements SOAPElement,
Serializable {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$message$MessageElement == null ? (class$org$apache$axis$message$MessageElement = MessageElement.class$("org.apache.axis.message.MessageElement")) : class$org$apache$axis$message$MessageElement).getName());
    private static final Mapping enc11Mapping = new Mapping("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
    private static final Mapping enc12Mapping = new Mapping("http://www.w3.org/2002/06/soap-encoding", "SOAP-ENC");
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected transient Attributes attributes = NullAttributes.singleton;
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelope message = null;
    protected boolean _isDirty = false;
    protected transient DeserializationContext context;
    protected transient QName typeQName = null;
    protected Vector qNameAttrs = null;
    protected transient SAX2EventRecorder recorder = null;
    protected int startEventIndex = 0;
    protected int startContentsIndex = 0;
    protected int endEventIndex = -1;
    protected Element elementRep = null;
    protected org.w3c.dom.Text textRep = null;
    protected MessageElement parent = null;
    public ArrayList namespaces = null;
    protected String encodingStyle = null;
    private Object objectValue = null;
    Deserializer fixupDeserializer;
    private ArrayList children = null;
    static /* synthetic */ Class class$org$apache$axis$message$MessageElement;

    public MessageElement() {
    }

    public MessageElement(String namespace, String localPart) {
        this.namespaceURI = namespace;
        this.name = localPart;
    }

    public MessageElement(String localPart, String prefix, String namespace) {
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
    }

    public MessageElement(Name eltName) {
        this(eltName.getURI(), eltName.getLocalName());
        this.prefix = eltName.getPrefix();
    }

    public MessageElement(String namespace, String localPart, Object value) {
        this(namespace, localPart);
        this.objectValue = value;
    }

    public MessageElement(QName name, Object value) {
        this(name.getNamespaceURI(), name.getLocalPart());
        this.objectValue = value;
    }

    public MessageElement(Element elem) {
        this.elementRep = elem;
        this.namespaceURI = elem.getNamespaceURI();
        this.name = elem.getLocalName();
    }

    public MessageElement(org.w3c.dom.Text text) {
        this.textRep = text;
        this.namespaceURI = text.getNamespaceURI();
        this.name = text.getLocalName();
    }

    public MessageElement(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("newElem00", super.toString(), "{" + prefix + "}" + localPart));
            int i = 0;
            while (attributes != null && i < attributes.getLength()) {
                log.debug((Object)("  " + attributes.getQName(i) + " = '" + attributes.getValue(i) + "'"));
                ++i;
            }
        }
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
        this.context = context;
        this.startEventIndex = context.getStartOfMappingsPos();
        this.setNSMappings(context.getCurrentNSMappings());
        this.recorder = context.getRecorder();
        if (attributes != null && attributes.getLength() > 0) {
            this.attributes = attributes;
            this.typeQName = context.getTypeFromAttributes(namespace, localPart, attributes);
            String rootVal = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
            if (rootVal != null) {
                this._isRoot = rootVal.equals("1");
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                context.registerElementByID(this.id, this);
                if (this.recorder == null) {
                    this.recorder = new SAX2EventRecorder();
                    context.setRecorder(this.recorder);
                }
            }
            this.href = attributes.getValue("href");
            if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            SOAPConstants sc = context.getMessageContext().getSOAPConstants();
            this.encodingStyle = attributes.getValue(sc.getEncodingURI(), "encodingStyle");
        }
    }

    public void setFixupDeserializer(Deserializer dser) {
        this.fixupDeserializer = dser;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int endIndex) {
        this.endEventIndex = endIndex;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean dirty) {
        this._isDirty = dirty;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Attributes getCompleteAttributes() {
        if (this.namespaces == null) {
            return this.attributes;
        }
        AttributesImpl attrs = new AttributesImpl(this.attributes);
        Iterator iterator = ((AbstractList)this.namespaces).iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            String prefix = mapping.getPrefix();
            String nsURI = mapping.getNamespaceURI();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, nsURI, "CDATA");
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName getQName() {
        return new QName(this.namespaceURI, this.name);
    }

    public void setQName(QName qName) {
        this.name = qName.getLocalPart();
        this.namespaceURI = qName.getNamespaceURI();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String nsURI) {
        this.namespaceURI = nsURI;
    }

    public QName getType() {
        MessageElement referent;
        if (this.typeQName == null && this.href != null && this.context != null && (referent = this.context.getElementByID(this.href)) != null) {
            this.typeQName = referent.getType();
        }
        return this.typeQName;
    }

    public void setType(QName qName) {
        this.typeQName = qName;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder rec) {
        this.recorder = rec;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return this.parent.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        if (!encodingStyle.equals("") && !Constants.isSOAP_ENC(encodingStyle)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException01", encodingStyle));
        }
        this.encodingStyle = encodingStyle;
        if (encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.addMapping(enc11Mapping);
        } else if (encodingStyle.equals("http://www.w3.org/2002/06/soap-encoding")) {
            this.addMapping(enc12Mapping);
        }
    }

    private MessageElement getParent() {
        return this.parent;
    }

    private void setParent(MessageElement parent) throws SOAPException {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(MessageElement el) throws SOAPException {
        if (this.objectValue != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("valuePresent"));
            log.error((Object)Messages.getMessage("valuePresent"), (Throwable)exc);
            throw exc;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(el);
        el.parent = this;
    }

    /*
     * WARNING - void declaration
     */
    public void removeChild(MessageElement child) {
        int i;
        while ((i = this.children.indexOf(child)) != -1) {
            void var2_2;
            this.children.remove((int)var2_2);
        }
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setContentsIndex(int index) {
        this.startContentsIndex = index;
    }

    public void setNSMappings(ArrayList namespaces) {
        this.namespaces = namespaces;
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (this.href != null) {
            return this.getRealElement().getPrefix(namespaceURI);
        }
        if (this.namespaces != null) {
            int i = 0;
            while (i < this.namespaces.size()) {
                Mapping map = (Mapping)this.namespaces.get(i);
                if (map.getNamespaceURI().equals(namespaceURI)) {
                    return map.getPrefix();
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.href != null) {
            return this.getRealElement().getNamespaceURI(prefix);
        }
        if (this.namespaces != null) {
            int i = 0;
            while (i < this.namespaces.size()) {
                Mapping map = (Mapping)this.namespaces.get(i);
                if (map.getPrefix().equals(prefix)) {
                    return map.getNamespaceURI();
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("noPrefix00", "" + this, prefix));
        }
        return null;
    }

    public Object getObjectValue() {
        if (this.objectValue == null) {
            try {
                this.objectValue = this.getValueAsType(this.getType());
            }
            catch (Exception e) {
                log.debug((Object)"getValue()", (Throwable)e);
            }
        }
        return this.objectValue;
    }

    public void setObjectValue(Object newValue) throws SOAPException {
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException exc = new SOAPException(Messages.getMessage("childPresent"));
            log.error((Object)Messages.getMessage("childPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.elementRep != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error((Object)Messages.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.textRep != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error((Object)Messages.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        this.objectValue = newValue;
    }

    public Object getValueAsType(QName type) throws Exception {
        if (this.context == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer dser = this.context.getDeserializerForType(type);
        if (dser == null) {
            throw new Exception(Messages.getMessage("noDeser00", "" + type));
        }
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)dser)));
        this.publishToHandler((ContentHandler)((Object)this.context));
        return dser.getValue();
    }

    public void addAttribute(String namespace, String localName, QName value) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr attr = new QNameAttr();
        attr.name = new QName(namespace, localName);
        attr.value = value;
        this.qNameAttrs.addElement(attr);
    }

    protected AttributesImpl makeAttributesEditable() {
        if (this.attributes == null || this.attributes instanceof NullAttributes) {
            this.attributes = new AttributesImpl();
        } else if (!(this.attributes instanceof AttributesImpl)) {
            this.attributes = new AttributesImpl(this.attributes);
        }
        return (AttributesImpl)this.attributes;
    }

    public void addAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        attributes.addAttribute(namespace, localName, "", "CDATA", value);
    }

    public void setAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        int idx = attributes.getIndex(namespace, localName);
        if (idx > -1) {
            if (value != null) {
                attributes.setValue(idx, value);
            } else {
                attributes.removeAttribute(idx);
            }
            return;
        }
        this.addAttribute(namespace, localName, value);
    }

    public String getAttributeValue(String localName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(localName);
    }

    public void setEnvelope(SOAPEnvelope env) {
        this.message = env;
    }

    public SOAPEnvelope getEnvelope() {
        return this.message;
    }

    public MessageElement getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object obj = this.context.getObjectByRef(this.href);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof MessageElement)) {
            return null;
        }
        return (MessageElement)obj;
    }

    public Document getAsDocument() throws Exception {
        String elementString = this.getAsString();
        StringReader reader = new StringReader(elementString);
        Document doc = XMLUtils.newDocument(new InputSource(reader));
        if (doc == null) {
            throw new Exception(Messages.getMessage("noDoc00", elementString));
        }
        return doc;
    }

    private String getAsString() throws Exception {
        SerializationContextImpl serializeContext = null;
        StringWriter writer = new StringWriter();
        MessageContext msgContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
        serializeContext = new SerializationContextImpl(writer, msgContext);
        serializeContext.setSendDecl(false);
        this.output(serializeContext);
        writer.close();
        return writer.getBuffer().toString();
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public void publishToHandler(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, handler);
    }

    public void publishContents(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, handler);
    }

    public final void output(SerializationContext context) throws Exception {
        if (this.recorder != null && !this._isDirty) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(context));
            return;
        }
        if (this.qNameAttrs != null) {
            int i = 0;
            while (i < this.qNameAttrs.size()) {
                QNameAttr attr = (QNameAttr)this.qNameAttrs.get(i);
                QName attrName = attr.name;
                this.addAttribute(attrName.getNamespaceURI(), attrName.getLocalPart(), context.qName2String(attr.value));
                ++i;
            }
            this.qNameAttrs = null;
        }
        if (this.encodingStyle != null) {
            SOAPConstants soapConstants;
            MessageContext mc = context.getMessageContext();
            SOAPConstants sOAPConstants = soapConstants = mc != null ? mc.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            if (this.parent == null) {
                if (!this.encodingStyle.equals("")) {
                    this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(this.parent.getEncodingStyle())) {
                this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(context);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        if (this.elementRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeDOMElement(this.elementRep);
            context.setPretty(oldPretty);
            return;
        }
        if (this.textRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeSafeString(this.textRep.getData());
            context.setPretty(oldPretty);
            return;
        }
        if (this.prefix != null) {
            context.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        if (this.objectValue != null) {
            context.serialize(new QName(this.namespaceURI, this.name), this.attributes, this.objectValue, null, false, Boolean.TRUE);
            return;
        }
        context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        if (this.children != null) {
            Iterator it = ((AbstractList)this.children).iterator();
            while (it.hasNext()) {
                ((MessageElement)it.next()).output(context);
            }
        }
        context.endElement();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exp) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exp);
            return null;
        }
    }

    public void addMapping(Mapping map) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.typeQName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.typeQName.getNamespaceURI());
            out.writeObject(this.typeQName.getLocalPart());
        }
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        int n = this.attributes.getLength();
        out.writeInt(n);
        int i = 0;
        while (i < n) {
            out.writeObject(this.attributes.getLocalName(i));
            out.writeObject(this.attributes.getQName(i));
            out.writeObject(this.attributes.getURI(i));
            out.writeObject(this.attributes.getType(i));
            out.writeObject(this.attributes.getValue(i));
            ++i;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.typeQName = in.readBoolean() ? new QName((String)in.readObject(), (String)in.readObject()) : null;
        AttributesImpl attributes = this.makeAttributesEditable();
        int n = in.readInt();
        int i = 0;
        while (i < n) {
            String localName = (String)in.readObject();
            String qName = (String)in.readObject();
            String uri = (String)in.readObject();
            String type = (String)in.readObject();
            String value = (String)in.readObject();
            attributes.addAttribute(uri, localName, qName, type, value);
            ++i;
        }
        in.defaultReadObject();
    }

    public String getValue() {
        try {
            Node node;
            Element element = this.getAsDOM();
            if (element.hasChildNodes() && (node = element.getFirstChild()).getNodeType() == 3) {
                return node.getNodeValue();
            }
        }
        catch (Exception t) {
            log.debug((Object)"getValue()", (Throwable)t);
        }
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            this.setParent((MessageElement)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public SOAPElement getParentElement() {
        return this.getParent();
    }

    public void detachNode() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public void recycleNode() {
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        MessageElement child = new MessageElement(name.getURI(), name.getLocalName());
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(), localName);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(prefix), localName);
        child.setPrefix(prefix);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        MessageElement child = new MessageElement(uri, localName);
        child.setPrefix(prefix);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        try {
            this.addChild((MessageElement)element);
            return element;
        }
        catch (ClassCastException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement addTextNode(String s) throws SOAPException {
        Text text = new Text(s);
        try {
            this.addChild(text);
            return this;
        }
        catch (ClassCastException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        try {
            this.addAttribute(name.getURI(), name.getLocalName(), value);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        try {
            Mapping map = new Mapping(uri, prefix);
            this.addMapping(map);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributes.getValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        int num = this.attributes.getLength();
        Vector<PrefixedQName> attrs = new Vector<PrefixedQName>(num);
        int i = 0;
        while (i < num) {
            int idx;
            String q = this.attributes.getQName(i);
            String prefix = "";
            if (q != null && (idx = q.indexOf(":")) > 0) {
                prefix = q.substring(0, idx);
            }
            attrs.add(new PrefixedQName(this.attributes.getURI(i), this.attributes.getLocalName(i), prefix));
            ++i;
        }
        return ((AbstractList)attrs).iterator();
    }

    public Iterator getNamespacePrefixes() {
        int num = this.namespaces.size();
        Vector<String> prefixes = new Vector<String>(num);
        int i = 0;
        while (i < num) {
            prefixes.add(((Mapping)this.namespaces.get(i)).getPrefix());
            ++i;
        }
        return ((AbstractList)prefixes).iterator();
    }

    public Name getElementName() {
        return new PrefixedQName(this.getNamespaceURI(), this.getName(), this.getPrefix());
    }

    public boolean removeAttribute(Name name) {
        AttributesImpl attributes = this.makeAttributesEditable();
        boolean removed = false;
        int i = 0;
        while (i < attributes.getLength() && !removed) {
            if (attributes.getURI(i).equals(name.getURI()) && attributes.getLocalName(i).equals(name.getLocalName())) {
                attributes.removeAttribute(i);
                removed = true;
            }
            ++i;
        }
        return removed;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        AttributesImpl attributes = this.makeAttributesEditable();
        boolean removed = false;
        int i = 0;
        while (i < this.namespaces.size() && !removed) {
            if (((Mapping)this.namespaces.get(i)).getPrefix().equals(prefix)) {
                this.namespaces.remove(i);
                removed = true;
            }
            ++i;
        }
        return removed;
    }

    public Iterator getChildElements() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return ((AbstractList)this.children).iterator();
    }

    public Iterator getChildElements(Name name) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        int num = this.children.size();
        Vector<MessageElement> c = new Vector<MessageElement>(num);
        int i = 0;
        while (i < num) {
            MessageElement child = (MessageElement)this.children.get(i);
            Name cname = child.getElementName();
            if (cname.getURI().equals(name.getURI()) && cname.getLocalName().equals(name.getLocalName())) {
                c.add(child);
            }
            ++i;
        }
        return ((AbstractList)c).iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class QNameAttr {
        QName name;
        QName value;

        protected QNameAttr() {
        }
    }
}

