/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.xml;

import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLWriterImpl
implements WSDLWriter {
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$com$ibm$wsdl$xml$WSDLWriterImpl;

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
    }

    private static void printDefinition(Definition def, PrintWriter pw) throws WSDLException {
        if (def == null) {
            return;
        }
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "definitions", def);
        pw.print('<' + tagName);
        QName name = def.getQName();
        String targetNamespace = def.getTargetNamespace();
        Map namespaces = def.getNamespaces();
        if (name != null) {
            DOMUtils.printAttribute("name", name.getLocalPart(), pw);
        }
        DOMUtils.printAttribute("targetNamespace", targetNamespace, pw);
        WSDLWriterImpl.printNamespaceDeclarations(namespaces, pw);
        pw.println('>');
        WSDLWriterImpl.printImports(def.getImports(), def, pw);
        WSDLWriterImpl.printDocumentation(def.getDocumentationElement(), pw);
        WSDLWriterImpl.printTypes(def.getTypes(), def, pw);
        WSDLWriterImpl.printMessages(def.getMessages(), def, pw);
        WSDLWriterImpl.printPortTypes(def.getPortTypes(), def, pw);
        WSDLWriterImpl.printBindings(def.getBindings(), def, pw);
        WSDLWriterImpl.printServices(def.getServices(), def, pw);
        List extElements = def.getExtensibilityElements();
        WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = WSDLWriterImpl.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, extElements, def, pw);
        pw.println("</" + tagName + '>');
        pw.flush();
    }

    private static void printServices(Map services, Definition def, PrintWriter pw) throws WSDLException {
        if (services != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "service", def);
            Iterator serviceIterator = services.values().iterator();
            while (serviceIterator.hasNext()) {
                Service service = (Service)serviceIterator.next();
                pw.print("  <" + tagName);
                QName name = service.getQName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(service.getDocumentationElement(), pw);
                WSDLWriterImpl.printPorts(service.getPorts(), def, pw);
                List extElements = service.getExtensibilityElements();
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Service == null ? WSDLWriterImpl.class$("javax.wsdl.Service") : class$javax$wsdl$Service, extElements, def, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    private static void printPorts(Map ports, Definition def, PrintWriter pw) throws WSDLException {
        if (ports != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "port", def);
            Iterator portIterator = ports.values().iterator();
            while (portIterator.hasNext()) {
                Port port = (Port)portIterator.next();
                pw.print("    <" + tagName);
                DOMUtils.printAttribute("name", port.getName(), pw);
                Binding binding = port.getBinding();
                if (binding != null) {
                    DOMUtils.printQualifiedAttribute("binding", binding.getQName(), def, pw);
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(port.getDocumentationElement(), pw);
                List extElements = port.getExtensibilityElements();
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Port == null ? WSDLWriterImpl.class$("javax.wsdl.Port") : class$javax$wsdl$Port, extElements, def, pw);
                pw.println("    </" + tagName + '>');
            }
        }
    }

    private static void printBindings(Map bindings, Definition def, PrintWriter pw) throws WSDLException {
        if (bindings != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "binding", def);
            Iterator bindingIterator = bindings.values().iterator();
            while (bindingIterator.hasNext()) {
                PortType portType;
                Binding binding = (Binding)bindingIterator.next();
                if (binding.isUndefined()) continue;
                pw.print("  <" + tagName);
                QName name = binding.getQName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                if ((portType = binding.getPortType()) != null) {
                    DOMUtils.printQualifiedAttribute("type", portType.getQName(), def, pw);
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(binding.getDocumentationElement(), pw);
                List extElements = binding.getExtensibilityElements();
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Binding == null ? WSDLWriterImpl.class$("javax.wsdl.Binding") : class$javax$wsdl$Binding, extElements, def, pw);
                WSDLWriterImpl.printBindingOperations(binding.getBindingOperations(), def, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    private static void printBindingOperations(List bindingOperations, Definition def, PrintWriter pw) throws WSDLException {
        if (bindingOperations != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "operation", def);
            Iterator bindingOperationIterator = bindingOperations.iterator();
            while (bindingOperationIterator.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)bindingOperationIterator.next();
                pw.print("    <" + tagName);
                DOMUtils.printAttribute("name", bindingOperation.getName(), pw);
                pw.println('>');
                WSDLWriterImpl.printDocumentation(bindingOperation.getDocumentationElement(), pw);
                List extElements = bindingOperation.getExtensibilityElements();
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingOperation == null ? WSDLWriterImpl.class$("javax.wsdl.BindingOperation") : class$javax$wsdl$BindingOperation, extElements, def, pw);
                WSDLWriterImpl.printBindingInput(bindingOperation.getBindingInput(), def, pw);
                WSDLWriterImpl.printBindingOutput(bindingOperation.getBindingOutput(), def, pw);
                WSDLWriterImpl.printBindingFaults(bindingOperation.getBindingFaults(), def, pw);
                pw.println("    </" + tagName + '>');
            }
        }
    }

    private static void printBindingInput(BindingInput bindingInput, Definition def, PrintWriter pw) throws WSDLException {
        if (bindingInput != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "input", def);
            pw.print("      <" + tagName);
            DOMUtils.printAttribute("name", bindingInput.getName(), pw);
            pw.println('>');
            WSDLWriterImpl.printDocumentation(bindingInput.getDocumentationElement(), pw);
            List extElements = bindingInput.getExtensibilityElements();
            WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = WSDLWriterImpl.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, extElements, def, pw);
            pw.println("      </" + tagName + '>');
        }
    }

    private static void printBindingOutput(BindingOutput bindingOutput, Definition def, PrintWriter pw) throws WSDLException {
        if (bindingOutput != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "output", def);
            pw.print("      <" + tagName);
            DOMUtils.printAttribute("name", bindingOutput.getName(), pw);
            pw.println('>');
            WSDLWriterImpl.printDocumentation(bindingOutput.getDocumentationElement(), pw);
            List extElements = bindingOutput.getExtensibilityElements();
            WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = WSDLWriterImpl.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, extElements, def, pw);
            pw.println("      </" + tagName + '>');
        }
    }

    private static void printBindingFaults(Map bindingFaults, Definition def, PrintWriter pw) throws WSDLException {
        if (bindingFaults != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "fault", def);
            Iterator bindingFaultIterator = bindingFaults.values().iterator();
            while (bindingFaultIterator.hasNext()) {
                BindingFault bindingFault = (BindingFault)bindingFaultIterator.next();
                pw.print("      <" + tagName);
                DOMUtils.printAttribute("name", bindingFault.getName(), pw);
                pw.println('>');
                WSDLWriterImpl.printDocumentation(bindingFault.getDocumentationElement(), pw);
                List extElements = bindingFault.getExtensibilityElements();
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingFault == null ? WSDLWriterImpl.class$("javax.wsdl.BindingFault") : class$javax$wsdl$BindingFault, extElements, def, pw);
                pw.println("      </" + tagName + '>');
            }
        }
    }

    private static void printPortTypes(Map portTypes, Definition def, PrintWriter pw) throws WSDLException {
        if (portTypes != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "portType", def);
            Iterator portTypeIterator = portTypes.values().iterator();
            while (portTypeIterator.hasNext()) {
                PortType portType = (PortType)portTypeIterator.next();
                if (portType.isUndefined()) continue;
                pw.print("  <" + tagName);
                QName name = portType.getQName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(portType.getDocumentationElement(), pw);
                WSDLWriterImpl.printOperations(portType.getOperations(), def, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    private static void printOperations(List operations, Definition def, PrintWriter pw) throws WSDLException {
        if (operations != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "operation", def);
            Iterator operationIterator = operations.iterator();
            while (operationIterator.hasNext()) {
                Operation operation = (Operation)operationIterator.next();
                if (operation.isUndefined()) continue;
                pw.print("    <" + tagName);
                DOMUtils.printAttribute("name", operation.getName(), pw);
                DOMUtils.printAttribute("parameterOrder", StringUtils.getNMTokens(operation.getParameterOrdering()), pw);
                pw.println('>');
                WSDLWriterImpl.printDocumentation(operation.getDocumentationElement(), pw);
                OperationType operationType = operation.getStyle();
                if (operationType == OperationType.ONE_WAY) {
                    WSDLWriterImpl.printInput(operation.getInput(), def, pw);
                } else if (operationType == OperationType.SOLICIT_RESPONSE) {
                    WSDLWriterImpl.printOutput(operation.getOutput(), def, pw);
                    WSDLWriterImpl.printInput(operation.getInput(), def, pw);
                } else if (operationType == OperationType.NOTIFICATION) {
                    WSDLWriterImpl.printOutput(operation.getOutput(), def, pw);
                } else {
                    WSDLWriterImpl.printInput(operation.getInput(), def, pw);
                    WSDLWriterImpl.printOutput(operation.getOutput(), def, pw);
                }
                WSDLWriterImpl.printFaults(operation.getFaults(), def, pw);
                pw.println("    </" + tagName + '>');
            }
        }
    }

    private static void printInput(Input input, Definition def, PrintWriter pw) throws WSDLException {
        if (input != null) {
            Element docEl;
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "input", def);
            pw.print("      <" + tagName);
            DOMUtils.printAttribute("name", input.getName(), pw);
            Message message = input.getMessage();
            if (message != null) {
                DOMUtils.printQualifiedAttribute("message", message.getQName(), def, pw);
            }
            if ((docEl = input.getDocumentationElement()) == null) {
                pw.println("/>");
            } else {
                pw.println('>');
                WSDLWriterImpl.printDocumentation(docEl, pw);
                pw.println("      </" + tagName + '>');
            }
        }
    }

    private static void printOutput(Output output, Definition def, PrintWriter pw) throws WSDLException {
        if (output != null) {
            Element docEl;
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "output", def);
            pw.print("      <" + tagName);
            DOMUtils.printAttribute("name", output.getName(), pw);
            Message message = output.getMessage();
            if (message != null) {
                DOMUtils.printQualifiedAttribute("message", message.getQName(), def, pw);
            }
            if ((docEl = output.getDocumentationElement()) == null) {
                pw.println("/>");
            } else {
                pw.println('>');
                WSDLWriterImpl.printDocumentation(docEl, pw);
                pw.println("      </" + tagName + '>');
            }
        }
    }

    private static void printFaults(Map faults, Definition def, PrintWriter pw) throws WSDLException {
        if (faults != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "fault", def);
            Iterator faultIterator = faults.values().iterator();
            while (faultIterator.hasNext()) {
                Element docEl;
                Fault fault = (Fault)faultIterator.next();
                pw.print("      <" + tagName);
                DOMUtils.printAttribute("name", fault.getName(), pw);
                Message message = fault.getMessage();
                if (message != null) {
                    DOMUtils.printQualifiedAttribute("message", message.getQName(), def, pw);
                }
                if ((docEl = fault.getDocumentationElement()) == null) {
                    pw.println("/>");
                    continue;
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(docEl, pw);
                pw.println("      </" + tagName + '>');
            }
        }
    }

    private static void printMessages(Map messages, Definition def, PrintWriter pw) throws WSDLException {
        if (messages != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "message", def);
            Iterator messageIterator = messages.values().iterator();
            while (messageIterator.hasNext()) {
                Message message = (Message)messageIterator.next();
                if (message.isUndefined()) continue;
                pw.print("  <" + tagName);
                QName name = message.getQName();
                if (name != null) {
                    DOMUtils.printAttribute("name", name.getLocalPart(), pw);
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(message.getDocumentationElement(), pw);
                WSDLWriterImpl.printParts(message.getOrderedParts(null), def, pw);
                pw.println("  </" + tagName + '>');
            }
        }
    }

    private static void printParts(List parts, Definition def, PrintWriter pw) throws WSDLException {
        if (parts != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "part", def);
            Iterator partIterator = parts.iterator();
            while (partIterator.hasNext()) {
                Part part = (Part)partIterator.next();
                pw.print("    <" + tagName);
                DOMUtils.printAttribute("name", part.getName(), pw);
                DOMUtils.printQualifiedAttribute("element", part.getElementName(), def, pw);
                DOMUtils.printQualifiedAttribute("type", part.getTypeName(), def, pw);
                Map extensionAttributes = part.getExtensionAttributes();
                Iterator attrNames = extensionAttributes.keySet().iterator();
                while (attrNames.hasNext()) {
                    QName attrName = (QName)attrNames.next();
                    QName attrValue = (QName)extensionAttributes.get(attrName);
                    DOMUtils.printQualifiedAttribute(attrName, attrValue, def, pw);
                }
                Element docEl = part.getDocumentationElement();
                if (docEl == null) {
                    pw.println("/>");
                    continue;
                }
                pw.println('>');
                WSDLWriterImpl.printDocumentation(docEl, pw);
                pw.println("      </" + tagName + '>');
            }
        }
    }

    private static void printDocumentation(Element docElement, PrintWriter pw) throws WSDLException {
        if (docElement != null) {
            DOM2Writer.serializeAsXML(docElement, pw);
            pw.println();
        }
    }

    private static void printTypes(Types types, Definition def, PrintWriter pw) throws WSDLException {
        if (types != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "types", def);
            pw.println("  <" + tagName + '>');
            WSDLWriterImpl.printDocumentation(types.getDocumentationElement(), pw);
            List extElements = types.getExtensibilityElements();
            WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Types == null ? (class$javax$wsdl$Types = WSDLWriterImpl.class$("javax.wsdl.Types")) : class$javax$wsdl$Types, extElements, def, pw);
            pw.println("  </" + tagName + '>');
        }
    }

    private static void printImports(Map imports, Definition def, PrintWriter pw) throws WSDLException {
        if (imports != null) {
            String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "import", def);
            Iterator importListIterator = imports.values().iterator();
            while (importListIterator.hasNext()) {
                List importList = (List)importListIterator.next();
                Iterator importIterator = importList.iterator();
                while (importIterator.hasNext()) {
                    Import importDef = (Import)importIterator.next();
                    pw.print("  <" + tagName);
                    DOMUtils.printAttribute("namespace", importDef.getNamespaceURI(), pw);
                    DOMUtils.printAttribute("location", importDef.getLocationURI(), pw);
                    Element docEl = importDef.getDocumentationElement();
                    if (docEl == null) {
                        pw.println("/>");
                        continue;
                    }
                    pw.println('>');
                    WSDLWriterImpl.printDocumentation(docEl, pw);
                    pw.println("      </" + tagName + '>');
                }
            }
        }
    }

    private static void printNamespaceDeclarations(Map namespaces, PrintWriter pw) throws WSDLException {
        if (namespaces != null) {
            Set keys = namespaces.keySet();
            Iterator keyIterator = keys.iterator();
            while (keyIterator.hasNext()) {
                String prefix = (String)keyIterator.next();
                if (prefix == null) {
                    prefix = "";
                }
                DOMUtils.printAttribute("xmlns" + (!prefix.equals("") ? ":" + prefix : ""), (String)namespaces.get(prefix), pw);
            }
        }
    }

    private static void printExtensibilityElements(Class parentType, List extensibilityElements, Definition def, PrintWriter pw) throws WSDLException {
        if (extensibilityElements != null) {
            Iterator extensibilityElementIterator = extensibilityElements.iterator();
            while (extensibilityElementIterator.hasNext()) {
                ExtensibilityElement ext = (ExtensibilityElement)extensibilityElementIterator.next();
                QName elementType = ext.getElementType();
                ExtensionRegistry extReg = def.getExtensionRegistry();
                if (extReg == null) {
                    throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to serialize a '" + elementType + "' element in the context of a '" + parentType.getName() + "'.");
                }
                ExtensionSerializer extSer = extReg.querySerializer(parentType, elementType);
                extSer.marshall(parentType, elementType, ext, pw, def, extReg);
            }
        }
    }

    private static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", t);
        }
    }

    public Document getDocument(Definition wsdlDef) throws WSDLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.writeWSDL(wsdlDef, pw);
        StringReader sr = new StringReader(sw.toString());
        InputSource is = new InputSource(sr);
        return WSDLWriterImpl.getDocument(is, "- WSDL Document -");
    }

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        PrintWriter pw = new PrintWriter(sink);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        WSDLWriterImpl.printDefinition(wsdlDef, pw);
    }

    public void writeWSDL(Definition wsdlDef, OutputStream sink) throws WSDLException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(sink, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(sink);
        }
        this.writeWSDL(wsdlDef, writer);
    }

    public static void main(String[] argv) throws WSDLException {
        if (argv.length == 1) {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
            wsdlWriter.writeWSDL(wsdlReader.readWSDL(null, argv[0]), System.out);
        } else {
            System.err.println("Usage:");
            System.err.println();
            System.err.println("  java " + (class$com$ibm$wsdl$xml$WSDLWriterImpl == null ? (class$com$ibm$wsdl$xml$WSDLWriterImpl = WSDLWriterImpl.class$("com.ibm.wsdl.xml.WSDLWriterImpl")) : class$com$ibm$wsdl$xml$WSDLWriterImpl).getName() + " filename|URL");
            System.err.println();
            System.err.println("This test driver simply reads a WSDL document into a model (using a WSDLReader), and then serializes it back to standard out. In effect, it performs a round-trip test on the specified WSDL document.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

