/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.soapstation;

import com.actional.config.BaseData;
import com.actional.soapapi.Util;
import com.actional.soapapi.soapstation.ApplicationTask;
import com.actional.soapapi.soapstation.SSTTask;
import com.actional.soapapi.soapstation.SdlTask;
import com.actional.soapapi.soapstation.TransportsTask;
import com.actional.soapstation.db.AccessPointNode;
import com.actional.soapstation.db.Application;
import com.actional.soapstation.db.Endpoint;
import com.actional.soapstation.db.JmsTransport;
import com.actional.soapstation.db.ManagedServiceNode;
import com.actional.soapstation.db.SvcGroup;
import com.actional.soapstation.db.Transport;
import com.actional.soapstation.db.WsdlBinding;
import com.actional.soapstation.db.XmlProcessorLC;
import com.actional.soapstation.task.WsdlBindingDef;
import com.actional.soapstation.task.WsdlContentDef;
import com.actional.soapstation.task.WsdlPortDef;
import java.util.List;

public class ServiceTask
extends SSTTask {
    public String createPassThroughGroup(GroupCreationInfo groupCreationInfo) throws Exception {
        if (groupCreationInfo == null) {
            return null;
        }
        Application application = (Application)this.findFirst(Application.class, groupCreationInfo.applicationName);
        Transport transport = (Transport)this.findFirst(Transport.class, groupCreationInfo.listenerName);
        Transport transport2 = (Transport)this.findFirst(Transport.class, groupCreationInfo.senderName);
        return this.createPassThroughGroup(groupCreationInfo, application, transport, transport2, null);
    }

    protected WsdlBindingPortDef firstWsdlBinding(String string, GroupCreationInfo groupCreationInfo) throws Exception {
        WsdlContentDef wsdlContentDef = ((SdlTask)this.createTask(SdlTask.class)).parseSDL(string, groupCreationInfo.getIgnoreProxy());
        WsdlBindingDef[] wsdlBindingDefArray = wsdlContentDef.getBindings();
        WsdlBindingDef wsdlBindingDef = wsdlBindingDefArray[0];
        WsdlPortDef[] wsdlPortDefArray = wsdlBindingDef.getPorts();
        WsdlPortDef wsdlPortDef = wsdlPortDefArray[0];
        System.out.println("Selecting port: " + wsdlPortDef.getName());
        WsdlBinding wsdlBinding = new WsdlBinding();
        wsdlBinding.setQName(wsdlBindingDef.getQName());
        wsdlBinding.setMetadata(wsdlContentDef.getMetadata());
        WsdlBindingPortDef wsdlBindingPortDef = new WsdlBindingPortDef();
        wsdlBindingPortDef.binding = wsdlBinding;
        wsdlBindingPortDef.portDef = wsdlPortDef;
        return wsdlBindingPortDef;
    }

    public String createPassThroughGroup(GroupCreationInfo groupCreationInfo, Application application, Transport transport, Transport transport2, XmlProcessorLC xmlProcessorLC) throws Exception {
        String string;
        if (groupCreationInfo == null) {
            return null;
        }
        String string2 = groupCreationInfo.uniqueKey;
        String string3 = groupCreationInfo.wsdlUrl;
        WsdlBindingPortDef wsdlBindingPortDef = this.firstWsdlBinding(string3, groupCreationInfo);
        if (Util.isBlank(string2)) {
            string2 = groupCreationInfo.groupName;
        }
        if (Util.isBlank((BaseData)application)) {
            application = ((ApplicationTask)this.createTask(ApplicationTask.class)).getDefaultApplication();
        }
        if (Util.isBlank((BaseData)application)) {
            application = new Application();
            string = groupCreationInfo.groupName;
            if (Util.isBlank(string)) {
                string = wsdlBindingPortDef.binding.getQName().getLocalName();
            }
            application.setKeyName(string);
            application = (Application)this.config()._getLeaf(this.config().appTask.createApplication(application));
        }
        if (Util.isBlank((BaseData)transport)) {
            transport = ((TransportsTask)this.createTask(TransportsTask.class)).defaultListener();
        }
        if (Util.isBlank((BaseData)transport2)) {
            transport2 = ((TransportsTask)this.createTask(TransportsTask.class)).defaultSender();
        }
        string = new SvcGroup();
        string.setKeyName(groupCreationInfo.groupName);
        string.setCategory(groupCreationInfo.category);
        AccessPointNode accessPointNode = new AccessPointNode();
        accessPointNode.setTransport(transport);
        accessPointNode.setUniqueKey(string2);
        accessPointNode.setDescription("Initial description");
        Endpoint endpoint = new Endpoint();
        endpoint.setTransport(transport2);
        if (!(transport2 instanceof JmsTransport)) {
            int n = string3.lastIndexOf(63);
            if (n == -1) {
                endpoint.setAddress(string3);
            } else {
                endpoint.setAddress(string3.substring(0, n));
            }
        }
        ManagedServiceNode managedServiceNode = new ManagedServiceNode();
        managedServiceNode.setEndpoint(endpoint);
        String string4 = this.config().serviceTask.addSimpleServiceGroup(wsdlBindingPortDef.binding, wsdlBindingPortDef.portDef, new Object[]{string, accessPointNode, managedServiceNode, application, xmlProcessorLC, groupCreationInfo.apOperations});
        this.config().serviceTask.activateServiceGroupRevision(string4);
        return string4;
    }

    protected static class WsdlBindingPortDef {
        WsdlBinding binding;
        WsdlPortDef portDef;

        protected WsdlBindingPortDef() {
        }
    }

    public static class GroupCreationInfo {
        public String groupName;
        public String category;
        public String uniqueKey;
        public String wsdlUrl;
        public String applicationName;
        public String listenerName;
        public String senderName;
        public List apOperations;
        private boolean ignoreProxy = true;

        public void setIgnoreProxy(boolean bl) {
            this.ignoreProxy = bl;
        }

        public boolean getIgnoreProxy() {
            return this.ignoreProxy;
        }
    }
}

