/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public final class ClassUtils {
    private static Class callContextClz;
    private static Method getDependenciesMethod;
    private static Hashtable classloaders;

    private ClassUtils() {
    }

    public static Class callContextClass() {
        if (callContextClz != null) {
            return callContextClz;
        }
        try {
            callContextClz = Class.forName("com.actional.CallContext");
            return callContextClz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException.toString());
        }
    }

    public static Class[] getDependencies(Class clazz) throws Exception {
        if (getDependenciesMethod == null) {
            Class<?> clazz2 = Class.forName("com.actional.config.Util");
            getDependenciesMethod = clazz2.getMethod("getDependencies", Class.class);
        }
        return (Class[])getDependenciesMethod.invoke(null, clazz);
    }

    public static void setClassLoader(String string, ClassLoader classLoader) {
        if (string != null && classLoader != null) {
            classloaders.put(string, classLoader);
        }
    }

    public static ClassLoader getClassLoader(String string) {
        if (string == null) {
            return null;
        }
        return (ClassLoader)classloaders.get(string);
    }

    public static void removeClassLoader(String string) {
        classloaders.remove(string);
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.loadClass(string);
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        final String string2 = string;
        final ClassLoader classLoader2 = classLoader;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string2, true, classLoader2);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            return ClassUtils.handleException(string, t);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ClassUtils.loadClass(string2);
        }
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        final String string2 = string;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ClassLoader classLoader = ClassUtils.getClassLoader(string2);
                    return Class.forName(string2, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        return Class.forName(string2, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            ClassLoader classLoader = ClassUtils.class.getClassLoader();
                            return Class.forName(string2, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException3) {
                            try {
                                return Class.forName(string2);
                            }
                            catch (Throwable throwable) {
                                return throwable;
                            }
                        }
                    }
                }
            }
        });
        return ClassUtils.handleException(string, t);
    }

    private static Class handleException(String string, Object object) throws ClassNotFoundException {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof ClassNotFoundException) {
            ClassNotFoundException classNotFoundException = (ClassNotFoundException)object;
            if (classNotFoundException.getMessage() == null) {
                throw new ClassNotFoundException(string, classNotFoundException);
            }
            throw classNotFoundException;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Throwable) {
            throw new ClassNotFoundException(string, (Throwable)object);
        }
        throw new ClassNotFoundException(string);
    }

    public static InputStream getResourceAsStream(Class clazz, String string) {
        InputStream inputStream = null;
        inputStream = clazz.getClassLoader() != null ? clazz.getClassLoader().getResourceAsStream(string) : ClassLoader.getSystemClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(string);
        }
        return inputStream;
    }

    static {
        classloaders = new Hashtable();
    }
}

