/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.jms.JMSVendorAdapterFactory;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.MapUtils;
import org.apache.axis.transport.jms.QueueConnector;
import org.apache.axis.transport.jms.TopicConnector;

public class JMSConnectorFactory {
    public static JMSConnector createServerConnector(HashMap connectorConfig, HashMap cfConfig, String username, String password) throws Exception {
        return JMSConnectorFactory.createConnector(connectorConfig, cfConfig, true, username, password);
    }

    public static JMSConnector createClientConnector(HashMap connectorConfig, HashMap cfConfig, String username, String password) throws Exception {
        return JMSConnectorFactory.createConnector(connectorConfig, cfConfig, false, username, password);
    }

    private static JMSConnector createConnector(HashMap connectorConfig, HashMap cfConfig, boolean allowReceive, String username, String password) throws Exception {
        if (connectorConfig != null) {
            connectorConfig = (HashMap)connectorConfig.clone();
        }
        int numRetries = MapUtils.removeIntProperty(connectorConfig, "transport.jms.NumRetries", 5);
        int numSessions = MapUtils.removeIntProperty(connectorConfig, "transport.jms.NumSessions", 5);
        long connectRetryInterval = MapUtils.removeLongProperty(connectorConfig, "transport.jms.ConnectRetryInterval", 2000L);
        long interactRetryInterval = MapUtils.removeLongProperty(connectorConfig, "transport.jms.InteractRetryInterval", 250L);
        long timeoutTime = MapUtils.removeLongProperty(connectorConfig, "transport.jms.TimeoutTime", 5000L);
        String clientID = MapUtils.removeStringProperty(connectorConfig, "transport.jms.ClientID", null);
        String domain = MapUtils.removeStringProperty(connectorConfig, "transport.jms.Domain", "QUEUE");
        if (cfConfig == null) {
            throw new IllegalArgumentException("noCfConfig");
        }
        JMSVendorAdapter adapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
        if (domain.equals("QUEUE")) {
            return new QueueConnector((ConnectionFactory)adapter.getQueueConnectionFactory(cfConfig), numRetries, numSessions, connectRetryInterval, interactRetryInterval, timeoutTime, allowReceive, clientID, username, password, adapter);
        }
        return new TopicConnector(adapter.getTopicConnectionFactory(cfConfig), numRetries, numSessions, connectRetryInterval, interactRetryInterval, timeoutTime, allowReceive, clientID, username, password, adapter);
    }
}

