/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.NoopGenerator;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaServiceWriter;
import org.apache.axis.wsdl.toJava.JavaTypeWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaGeneratorFactory
implements GeneratorFactory {
    protected Emitter emitter;
    protected SymbolTable symbolTable;
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_CLASS_NAME = "ExceptionClassName";
    private Writers messageWriters = new Writers();
    private Writers portTypeWriters = new Writers();
    private Writers bindingWriters = new Writers();
    private Writers serviceWriters = new Writers();
    private Writers typeWriters = new Writers();
    private Writers defWriters = new Writers();
    BaseTypeMapping btm = null;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaDeployWriter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaUndeployWriter;
    static /* synthetic */ Class class$javax$wsdl$Message;
    static /* synthetic */ Class class$javax$wsdl$PortType;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$TypeEntry;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.emitter = emitter;
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    protected void addMessageGenerators() {
    }

    protected void addPortTypeGenerators() {
    }

    protected void addBindingGenerators() {
    }

    protected void addServiceGenerators() {
    }

    protected void addTypeGenerators() {
    }

    protected void addDefinitionGenerators() {
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter = JavaGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaDefinitionWriter")) : class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter);
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaDeployWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaDeployWriter = JavaGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaDeployWriter")) : class$org$apache$axis$wsdl$toJava$JavaDeployWriter);
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaUndeployWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaUndeployWriter = JavaGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaUndeployWriter")) : class$org$apache$axis$wsdl$toJava$JavaUndeployWriter);
    }

    public void generatorPass(Definition def, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.setFaultContext(symbolTable);
        this.resolveNameClashes(symbolTable);
        this.determineInterfaceNames(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public Generator getGenerator(Message message, SymbolTable symbolTable) {
        MessageEntry mEntry = symbolTable.getMessageEntry(message.getQName());
        this.messageWriters.addStuff((Generator)new NoopGenerator(), mEntry, symbolTable);
        return this.messageWriters;
    }

    public Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
        this.portTypeWriters.addStuff((Generator)new NoopGenerator(), ptEntry, symbolTable);
        return this.portTypeWriters;
    }

    public Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        JavaBindingWriter writer = new JavaBindingWriter(this.emitter, binding, symbolTable);
        BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
        this.bindingWriters.addStuff((Generator)writer, bEntry, symbolTable);
        return this.bindingWriters;
    }

    public Generator getGenerator(Service service, SymbolTable symbolTable) {
        JavaServiceWriter writer = new JavaServiceWriter(this.emitter, service, symbolTable);
        ServiceEntry sEntry = symbolTable.getServiceEntry(service.getQName());
        this.serviceWriters.addStuff((Generator)writer, sEntry, symbolTable);
        return this.serviceWriters;
    }

    public Generator getGenerator(TypeEntry type, SymbolTable symbolTable) {
        JavaTypeWriter writer = new JavaTypeWriter(this.emitter, type, symbolTable);
        this.typeWriters.addStuff((Generator)writer, type, symbolTable);
        return this.typeWriters;
    }

    public Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        this.defWriters.addStuff(null, definition, symbolTable);
        return this.defWriters;
    }

    public void addGenerator(Class wsdlClass, Class generator) {
        if ((class$javax$wsdl$Message == null ? (class$javax$wsdl$Message = JavaGeneratorFactory.class$("javax.wsdl.Message")) : class$javax$wsdl$Message).isAssignableFrom(wsdlClass)) {
            this.messageWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$PortType == null ? (class$javax$wsdl$PortType = JavaGeneratorFactory.class$("javax.wsdl.PortType")) : class$javax$wsdl$PortType).isAssignableFrom(wsdlClass)) {
            this.portTypeWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = JavaGeneratorFactory.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding).isAssignableFrom(wsdlClass)) {
            this.bindingWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Service == null ? (class$javax$wsdl$Service = JavaGeneratorFactory.class$("javax.wsdl.Service")) : class$javax$wsdl$Service).isAssignableFrom(wsdlClass)) {
            this.serviceWriters.addGenerator(generator);
        } else if ((class$org$apache$axis$wsdl$symbolTable$TypeEntry == null ? (class$org$apache$axis$wsdl$symbolTable$TypeEntry = JavaGeneratorFactory.class$("org.apache.axis.wsdl.symbolTable.TypeEntry")) : class$org$apache$axis$wsdl$symbolTable$TypeEntry).isAssignableFrom(wsdlClass)) {
            this.typeWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition).isAssignableFrom(wsdlClass)) {
            this.defWriters.addGenerator(generator);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        int uniqueNum = 0;
        HashMap<QName, QName> anonQNames = new HashMap<QName, QName>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry.getName() == null) {
                    if (entry instanceof TypeEntry) {
                        TypeEntry tEntry = (TypeEntry)entry;
                        String dims = tEntry.getDimensions();
                        TypeEntry refType = tEntry.getRefType();
                        while (refType != null) {
                            tEntry = refType;
                            dims = dims + tEntry.getDimensions();
                            refType = tEntry.getRefType();
                        }
                        if (tEntry.getName() == null) {
                            QName typeQName = tEntry.getQName();
                            if (typeQName.getLocalPart().indexOf(">") < 0) {
                                tEntry.setName(this.emitter.getJavaName(typeQName));
                            } else {
                                String localName = typeQName.getLocalPart();
                                localName = localName.substring(localName.lastIndexOf(">") + 1);
                                typeQName = new QName(typeQName.getNamespaceURI(), localName);
                                symbolTable.getType(typeQName);
                                if (anonQNames.get(typeQName) != null) {
                                    localName = localName + "Type" + uniqueNum++;
                                    typeQName = new QName(typeQName.getNamespaceURI(), localName);
                                }
                                anonQNames.put(typeQName, typeQName);
                                tEntry.setName(this.emitter.getJavaName(typeQName));
                            }
                        }
                        entry.setName(tEntry.getName() + dims);
                    } else {
                        entry.setName(this.emitter.getJavaName(entry.getQName()));
                    }
                }
                ++i;
            }
        }
    }

    private void setFaultContext(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                    PortType portType = ptEntry.getPortType();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        Parameters parameters = bEntry.getParameters(operation);
                        Iterator iFault = parameters.faults.values().iterator();
                        while (iFault.hasNext()) {
                            Fault fault = (Fault)iFault.next();
                            this.setFaultContext(fault, symbolTable);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void setFaultContext(Fault fault, SymbolTable symbolTable) {
        Vector parts = new Vector();
        try {
            symbolTable.getParametersFromParts(parts, fault.getMessage().getOrderedParts(null), false, fault.getName(), null);
        }
        catch (IOException e) {
            // empty catch block
        }
        String exceptionClassName = null;
        int j = 0;
        while (j < parts.size()) {
            TypeEntry te = ((Parameter)parts.elementAt(j)).getType();
            TypeEntry elementTE = null;
            if (te instanceof Element) {
                elementTE = te;
                te = te.getRefType();
            }
            if (te.getBaseType() == null && !te.isSimpleType()) {
                Boolean isComplexFault = (Boolean)te.getDynamicVar(COMPLEX_TYPE_FAULT);
                if (isComplexFault == null || !isComplexFault.booleanValue()) {
                    te.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                    if (elementTE != null) {
                        te.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                    }
                    HashSet derivedSet = org.apache.axis.wsdl.symbolTable.Utils.getDerivedTypes(te, symbolTable);
                    Iterator derivedI = derivedSet.iterator();
                    while (derivedI.hasNext()) {
                        TypeEntry derivedTE = (TypeEntry)derivedI.next();
                        derivedTE.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                    }
                    TypeEntry base = SchemaUtils.getComplexElementExtensionBase(te.getNode(), symbolTable);
                    while (base != null) {
                        base.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                        base = SchemaUtils.getComplexElementExtensionBase(base.getNode(), symbolTable);
                    }
                }
                exceptionClassName = te.getName();
            }
            ++j;
        }
        MessageEntry me = symbolTable.getMessageEntry(fault.getMessage().getQName());
        if (me != null) {
            if (exceptionClassName != null) {
                me.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                me.setDynamicVar(EXCEPTION_CLASS_NAME, exceptionClassName);
            } else {
                me.setDynamicVar(EXCEPTION_CLASS_NAME, this.emitter.getJavaName(me.getQName()));
            }
        }
    }

    protected void determineInterfaceNames(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    String seiName = null;
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
                    seiName = ptEntry.getName();
                    bEntry.setDynamicVar(JavaBindingWriter.INTERFACE_NAME, seiName);
                }
                ++i;
            }
        }
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        HashSet<Type> anonTypes = new HashSet<Type>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            SymTabEntry entry;
            Vector<TypeEntry> v = new Vector<TypeEntry>((Vector)it.next());
            int index = 0;
            while (index < v.size()) {
                if (v.elementAt(index) instanceof MessageEntry) {
                    v.removeElementAt(index);
                    continue;
                }
                ++index;
            }
            if (v.size() <= 1) continue;
            boolean resolve = true;
            if (v.size() == 2 && (v.elementAt(0) instanceof Element && v.elementAt(1) instanceof Type || v.elementAt(1) instanceof Element && v.elementAt(0) instanceof Type)) {
                Element e = null;
                e = v.elementAt(0) instanceof Element ? (Element)v.elementAt(0) : (Element)v.elementAt(1);
                BooleanHolder forElement = new BooleanHolder();
                QName eType = org.apache.axis.wsdl.symbolTable.Utils.getTypeQName(e.getNode(), forElement, false);
                if (eType != null && eType.equals(e.getQName()) && !forElement.value) {
                    resolve = false;
                }
            }
            if (resolve) {
                resolve = false;
                String name = null;
                int i = 0;
                while (i < v.size() && !resolve) {
                    entry = (SymTabEntry)v.elementAt(i);
                    if (!(entry instanceof MessageEntry) && !(entry instanceof BindingEntry)) {
                        if (name == null) {
                            name = entry.getName();
                        } else if (name.equals(entry.getName())) {
                            resolve = true;
                        }
                    }
                    ++i;
                }
            }
            if (!resolve) continue;
            boolean firstType = true;
            int i = 0;
            while (i < v.size()) {
                BindingEntry bEntry;
                entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof Element) {
                    entry.setName(this.mangleName(entry.getName(), "_ElemType"));
                    QName anonQName = new QName(entry.getQName().getNamespaceURI(), ">" + entry.getQName().getLocalPart());
                    Type anonType = symbolTable.getType(anonQName);
                    if (anonType != null) {
                        anonType.setName(entry.getName());
                        anonTypes.add(anonType);
                    }
                } else if (entry instanceof TypeEntry) {
                    if (firstType) {
                        firstType = false;
                        Vector types = symbolTable.getTypes();
                        int j = 0;
                        while (j < types.size()) {
                            TypeEntry type = (TypeEntry)types.elementAt(j);
                            if (type != entry && !(type instanceof Element) && type.getBaseType() == null && this.sameJavaClass(((Type)entry).getName(), type.getName())) {
                                v.add(type);
                            }
                            ++j;
                        }
                    }
                    if (!anonTypes.contains(entry)) {
                        entry.setName(this.mangleName(entry.getName(), "_Type"));
                    }
                } else if (entry instanceof PortTypeEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Port"));
                } else if (entry instanceof ServiceEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Service"));
                } else if (entry instanceof BindingEntry && (bEntry = (BindingEntry)entry).hasLiteral()) {
                    entry.setName(this.mangleName(entry.getName(), "_Binding"));
                }
                ++i;
            }
        }
    }

    private String mangleName(String name, String mangle) {
        int index = name.indexOf("[");
        if (index >= 0) {
            String pre = name.substring(0, index);
            String post = name.substring(index);
            return pre + mangle + post;
        }
        return name + mangle;
    }

    private boolean sameJavaClass(String one, String two) {
        int index1 = one.indexOf("[");
        int index2 = two.indexOf("[");
        if (index1 > 0) {
            one = one.substring(0, index1);
        }
        if (index2 > 0) {
            two = two.substring(0, index2);
        }
        return one.equals(two);
    }

    protected void setAllReferencesToTrue() {
        Iterator it = this.symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry && ((BindingEntry)entry).getBindingType() != 0) {
                    entry.setIsReferenced(false);
                } else {
                    entry.setIsReferenced(true);
                }
                ++i;
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> unusedPortTypes = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> usedPortTypes = new Vector<PortTypeEntry>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    PortType portType = binding.getPortType();
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
                    if (bEntry.getBindingType() == 0) {
                        usedPortTypes.add(ptEntry);
                        if (unusedPortTypes.contains(ptEntry)) {
                            unusedPortTypes.remove(ptEntry);
                        }
                    } else {
                        bEntry.setIsReferenced(false);
                        if (!usedPortTypes.contains(ptEntry)) {
                            unusedPortTypes.add(ptEntry);
                        }
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < unusedPortTypes.size()) {
            PortTypeEntry ptEntry = (PortTypeEntry)unusedPortTypes.get(i);
            ptEntry.setIsReferenced(false);
            ++i;
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                    PortType portType = ptEntry.getPortType();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        OperationType type = operation.getStyle();
                        String name = operation.getName();
                        Parameters parameters = bEntry.getParameters(operation);
                        if (type == OperationType.SOLICIT_RESPONSE) {
                            parameters.signature = "    // " + Messages.getMessage("invalidSolResp00", name);
                            System.err.println(Messages.getMessage("invalidSolResp00", name));
                            continue;
                        }
                        if (type == OperationType.NOTIFICATION) {
                            parameters.signature = "    // " + Messages.getMessage("invalidNotif00", name);
                            System.err.println(Messages.getMessage("invalidNotif00", name));
                            continue;
                        }
                        parameters.signature = this.constructSignature(parameters, name);
                    }
                }
                ++i;
            }
        }
    }

    private String constructSignature(Parameters parms, String opName) {
        String name = Utils.xmlNameToJava(opName);
        String ret = "void";
        if (parms.returnParam != null) {
            ret = Utils.getParameterTypeName(parms.returnParam);
        }
        String signature = "    public " + ret + " " + name + "(";
        boolean needComma = false;
        int i = 0;
        while (i < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i);
            if (needComma) {
                signature = signature + ", ";
            } else {
                needComma = true;
            }
            String javifiedName = Utils.xmlNameToJava(p.getName());
            signature = p.getMode() == 1 ? signature + Utils.getParameterTypeName(p) + " " + javifiedName : signature + Utils.holder(p.getMIMEType(), p.getType(), this.emitter) + " " + javifiedName;
            ++i;
        }
        signature = signature + ") throws java.rmi.RemoteException";
        if (parms.faults != null) {
            Iterator i2 = parms.faults.values().iterator();
            while (i2.hasNext()) {
                Fault fault = (Fault)i2.next();
                String exceptionName = Utils.getFullExceptionName(fault, this.emitter);
                signature = signature + ", " + exceptionName;
            }
        }
        return signature;
    }

    protected void determineIfHoldersNeeded(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)v.get(i);
                    Iterator operations = bEntry.getParameters().values().iterator();
                    while (operations.hasNext()) {
                        Parameters parms = (Parameters)operations.next();
                        int j = 0;
                        while (j < parms.list.size()) {
                            Parameter p = (Parameter)parms.list.get(j);
                            if (p.getMode() != 1) {
                                Type anonType;
                                QName anonQName;
                                TypeEntry typeEntry = p.getType();
                                typeEntry.setDynamicVar("Holder is needed", new Boolean(true));
                                if (!typeEntry.isSimpleType() && typeEntry.getRefType() != null) {
                                    typeEntry.getRefType().setDynamicVar("Holder is needed", new Boolean(true));
                                }
                                if ((anonQName = SchemaUtils.getElementAnonQName(p.getType().getNode())) != null && (anonType = symbolTable.getType(anonQName)) != null) {
                                    anonType.setDynamicVar("Holder is needed", new Boolean(true));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping btm) {
        this.btm = btm;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

                public String getBaseName(QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }
            };
        }
        return this.btm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Writers
    implements Generator {
        Vector writers = new Vector();
        SymbolTable symbolTable = null;
        Generator baseWriter = null;
        SymTabEntry entry = null;
        Definition def = null;
        static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$Emitter;
        static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$SymbolTable;
        static /* synthetic */ Class class$javax$wsdl$Definition;

        Writers() {
        }

        public void addGenerator(Class writer) {
            this.writers.add(writer);
        }

        public void addStuff(Generator baseWriter, SymTabEntry entry, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.entry = entry;
            this.symbolTable = symbolTable;
        }

        public void addStuff(Generator baseWriter, Definition def, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.def = def;
            this.symbolTable = symbolTable;
        }

        public void generate() throws IOException {
            if (this.baseWriter != null) {
                this.baseWriter.generate();
            }
            Class[] formalArgs = null;
            Object[] actualArgs = null;
            if (this.entry != null) {
                formalArgs = new Class[]{class$org$apache$axis$wsdl$toJava$Emitter == null ? (class$org$apache$axis$wsdl$toJava$Emitter = Writers.class$("org.apache.axis.wsdl.toJava.Emitter")) : class$org$apache$axis$wsdl$toJava$Emitter, this.entry.getClass(), class$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$org$apache$axis$wsdl$symbolTable$SymbolTable = Writers.class$("org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{JavaGeneratorFactory.this.emitter, this.entry, this.symbolTable};
            } else {
                formalArgs = new Class[]{class$org$apache$axis$wsdl$toJava$Emitter == null ? (class$org$apache$axis$wsdl$toJava$Emitter = Writers.class$("org.apache.axis.wsdl.toJava.Emitter")) : class$org$apache$axis$wsdl$toJava$Emitter, class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = Writers.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$org$apache$axis$wsdl$symbolTable$SymbolTable = Writers.class$("org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{JavaGeneratorFactory.this.emitter, this.def, this.symbolTable};
            }
            int i = 0;
            while (i < this.writers.size()) {
                Class wClass = (Class)this.writers.get(i);
                Generator gen = null;
                try {
                    Constructor ctor = wClass.getConstructor(formalArgs);
                    gen = (Generator)ctor.newInstance(actualArgs);
                }
                catch (Throwable t) {
                    throw new IOException(Messages.getMessage("exception01", t.getMessage()));
                }
                gen.generate();
                ++i;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

