/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDUndeployment
extends WSDDElement
implements WSDDTypeMappingContainer {
    private Vector handlers = new Vector();
    private Vector chains = new Vector();
    private Vector services = new Vector();
    private Vector transports = new Vector();
    private Vector typeMappings = new Vector();

    public void addHandler(QName handler) {
        this.handlers.add(handler);
    }

    public void addChain(QName chain) {
        this.chains.add(chain);
    }

    public void addTransport(QName transport) {
        this.transports.add(transport);
    }

    public void addService(QName service) {
        this.services.add(service);
    }

    public void deployTypeMapping(WSDDTypeMapping typeMapping) throws WSDDException {
        this.typeMappings.add(typeMapping);
    }

    public WSDDUndeployment() {
    }

    private QName getQName(Element el) throws WSDDException {
        String attr = el.getAttribute("name");
        if (attr == null || "".equals(attr)) {
            throw new WSDDException(Messages.getMessage("badNameAttr00"));
        }
        return new QName("", attr);
    }

    public WSDDUndeployment(Element e) throws WSDDException {
        super(e);
        Element[] elements = this.getChildElements(e, "handler");
        int i = 0;
        while (i < elements.length) {
            this.addHandler(this.getQName(elements[i]));
            ++i;
        }
        elements = this.getChildElements(e, "chain");
        i = 0;
        while (i < elements.length) {
            this.addChain(this.getQName(elements[i]));
            ++i;
        }
        elements = this.getChildElements(e, "transport");
        i = 0;
        while (i < elements.length) {
            this.addTransport(this.getQName(elements[i]));
            ++i;
        }
        elements = this.getChildElements(e, "service");
        i = 0;
        while (i < elements.length) {
            this.addService(this.getQName(elements[i]));
            ++i;
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_UNDEPLOY;
    }

    public void undeployFromRegistry(WSDDDeployment registry) throws ConfigurationException {
        QName qname;
        int n = 0;
        while (n < this.handlers.size()) {
            qname = (QName)this.handlers.get(n);
            registry.undeployHandler(qname);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.chains.size()) {
            qname = (QName)this.chains.get(n2);
            registry.undeployHandler(qname);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.transports.size()) {
            qname = (QName)this.transports.get(n3);
            registry.undeployTransport(qname);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.services.size()) {
            qname = (QName)this.services.get(n4);
            registry.undeployService(qname);
            ++n4;
        }
    }

    private void writeElement(SerializationContext context, QName elementQName, QName qname) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "CDATA", context.qName2String(qname));
        context.startElement(elementQName, attrs);
        context.endElement();
    }

    public void writeToContext(SerializationContext context) throws IOException {
        QName qname;
        context.registerPrefixForURI("", "http://xml.apache.org/axis/wsdd/");
        context.startElement(WSDDConstants.QNAME_UNDEPLOY, null);
        Iterator i = ((AbstractList)this.handlers).iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, WSDDConstants.QNAME_HANDLER, qname);
        }
        i = ((AbstractList)this.chains).iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, WSDDConstants.QNAME_CHAIN, qname);
        }
        i = ((AbstractList)this.services).iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, WSDDConstants.QNAME_SERVICE, qname);
        }
        i = ((AbstractList)this.transports).iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, WSDDConstants.QNAME_TRANSPORT, qname);
        }
        i = ((AbstractList)this.typeMappings).iterator();
        while (i.hasNext()) {
            WSDDTypeMapping mapping = (WSDDTypeMapping)i.next();
            mapping.writeToContext(context);
        }
        context.endElement();
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] t = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(t);
        return t;
    }
}

