/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi;

import com.actional.config.BaseData;
import com.actional.soapapi.Util;
import com.actional.soapstation.task.IConfigTask;
import com.actional.soapstation.task.IConfigTaskServiceLocator;
import com.actional.soapstation.task.IProductInfoTask;
import com.actional.soapstation.task.IProductInfoTaskServiceLocator;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;

public class Config {
    protected IConfigTaskServiceLocator configTaskLocator = new IConfigTaskServiceLocator(){

        public javax.xml.rpc.Call createCall() throws ServiceException {
            return Config.this.prepareCall(super.createCall());
        }
    };
    protected IProductInfoTaskServiceLocator productInfoTaskLocator = new IProductInfoTaskServiceLocator(){

        public javax.xml.rpc.Call createCall() throws ServiceException {
            return Config.this.prepareCall(super.createCall());
        }
    };
    public IConfigTask configTask;
    public IProductInfoTask productInfoTask;
    protected String itsUserName;
    protected String itsPassword;
    protected String itsEndpoint;
    protected String itsImpersonateCookie;
    protected boolean itsMaintainSession;

    public Config(String string, String string2, String string3) {
        this.itsUserName = string;
        this.itsPassword = string2;
        this.itsEndpoint = string3;
    }

    public boolean getMaintainSession() {
        return this.itsMaintainSession;
    }

    public void setMaintainSession(boolean bl) {
        this.itsMaintainSession = bl;
    }

    public void setImpersonate(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl = false;
        stringBuilder.append("Actional_Impersonate=");
        if (!Util.isBlank(string)) {
            bl = true;
            stringBuilder.append(string);
        }
        if (!Util.isBlank(string2) || !Util.isBlank(string3)) {
            bl = true;
            stringBuilder.append('/');
            if (!Util.isBlank(string2)) {
                stringBuilder.append(string2);
            }
            if (!Util.isBlank(string3)) {
                stringBuilder.append('/');
                stringBuilder.append(string3);
            }
        }
        this.itsImpersonateCookie = bl ? stringBuilder.toString() : null;
    }

    public void init() throws Exception {
        try {
            this.prepareTasks();
        }
        catch (Exception exception) {
            throw new Exception("Failed to initialize SOAP API connection.", exception);
        }
    }

    protected void prepareTasks() throws ServiceException, MalformedURLException {
        this.configTask = this.configTaskLocator.getIConfigTask(this.proxyUrl(this.configTaskLocator.getIConfigTaskAddress()));
        this.productInfoTask = this.productInfoTaskLocator.getIProductInfoTask(this.proxyUrl(this.productInfoTaskLocator.getIProductInfoTaskAddress()));
        this.prepareStub(this.configTask);
        this.prepareStub(this.productInfoTask);
    }

    protected void prepareStub(Object object) {
        Stub stub = (Stub)object;
        stub.setUsername(this.itsUserName);
        stub.setPassword(this.itsPassword);
        stub.setMaintainSession(this.itsMaintainSession);
        stub._setProperty("send_type_attr", (Object)Boolean.FALSE);
    }

    protected URL proxyUrl(String string) throws MalformedURLException {
        int n;
        String string2 = string;
        if (this.itsEndpoint != null && (n = string.lastIndexOf("/api")) > 0) {
            string2 = string.substring(n);
            string2 = this.itsEndpoint + string2;
        }
        return new URL(string2);
    }

    public javax.xml.rpc.Call prepareCall(javax.xml.rpc.Call call) throws ServiceException {
        Call call2 = (Call)call;
        if (call2 == null) {
            return null;
        }
        if (!Util.isBlank(this.itsImpersonateCookie)) {
            call2.setScopedProperty("Cookie", (Object)this.itsImpersonateCookie);
            call2.setScopedProperty("Cookie2", (Object)this.itsImpersonateCookie);
        }
        return call2;
    }

    public BaseData acervate(String string) throws RemoteException {
        return this.configTask.get(string);
    }

    public BaseData acervate(BaseData baseData) throws RemoteException {
        if (baseData == null) {
            return null;
        }
        if (Util.isLeaf(baseData)) {
            return this.acervate(baseData.getKeyID());
        }
        return baseData;
    }

    public void acervate(BaseData[] baseDataArray) throws RemoteException {
        if (baseDataArray == null) {
            return;
        }
        int n = baseDataArray.length;
        for (int i = 0; i < n; ++i) {
            baseDataArray[i] = this.acervate(baseDataArray[i]);
        }
    }

    public BaseData _getLeaf(String string) throws Exception {
        return Util.createLeaf(this.configTask.get(string));
    }

    public BaseData[] find(Class<? extends BaseData> clazz) throws Exception {
        return this.find(clazz, null);
    }

    public BaseData[] find(Class<? extends BaseData> clazz, String string) throws Exception {
        BaseData baseData = clazz.newInstance();
        baseData.setKeyName(string);
        return this.configTask.find(baseData);
    }

    public BaseData findFirst(Class<? extends BaseData> clazz, String string) throws Exception {
        BaseData baseData = this.findFirstIfExists(clazz, string);
        if (Util.isBlank(baseData)) {
            throw new Exception("Failed to locate classes of type '" + clazz.getName() + "' with a KeyName of '" + string + "'");
        }
        return baseData;
    }

    public BaseData findFirstIfExists(Class<? extends BaseData> clazz, String string) throws Exception {
        Object[] objectArray = this.find(clazz, string);
        if (Util.isBlank(objectArray)) {
            return null;
        }
        return objectArray[0];
    }

    public BaseData findFirst(BaseData baseData) throws Exception {
        BaseData baseData2 = this.findFirstIfExists(baseData);
        if (Util.isBlank(baseData2)) {
            throw new Exception("Failed to locate BaseData with criteria: " + baseData);
        }
        return baseData2;
    }

    public BaseData findFirstIfExists(BaseData baseData) throws Exception {
        Object[] objectArray = this.configTask.find(baseData);
        if (Util.isBlank(objectArray)) {
            return null;
        }
        return objectArray[0];
    }

    public BaseData[] findHiddenUsers(String string) throws Exception {
        return this.configTask.findHiddenUsers(string);
    }

    public BaseData[] findHiddenUsers(BaseData baseData) throws Exception {
        return this.findHiddenUsers(baseData.getKeyID());
    }

    public BaseData findFirstHiddenUser(String string) throws Exception {
        Object[] objectArray = this.findHiddenUsers(string);
        if (Util.isBlank(objectArray)) {
            throw new Exception("Failed to locate a user of the class with a keyID of: " + string);
        }
        return objectArray[0];
    }

    public BaseData findFirstHiddenUser(BaseData baseData) throws Exception {
        return this.findFirstHiddenUser(baseData.getKeyID());
    }

    public boolean canRead(BaseData baseData) throws Exception {
        if (baseData == null) {
            return false;
        }
        return this.configTask.canRead(Util.createLeaf(baseData), null, -1);
    }

    public boolean canWrite(BaseData baseData) throws Exception {
        if (baseData == null) {
            return false;
        }
        return this.configTask.canWrite(Util.createLeaf(baseData), null, -1);
    }

    public boolean canCreate(BaseData baseData) throws Exception {
        if (baseData == null) {
            return false;
        }
        return this.configTask.canCreate(Util.createLeaf(baseData), null, -1);
    }

    public boolean canDelete(BaseData baseData) throws Exception {
        if (baseData == null) {
            return false;
        }
        return this.configTask.canDelete(Util.createLeaf(baseData), null, -1);
    }
}

