/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import sun.security.provider.Sun;

public class JSSESocketFactory
extends DefaultSocketFactory {
    private String keystoreType;
    static String defaultKeystoreType = "JKS";
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static boolean defaultClientAuth = false;
    private boolean clientAuth = false;
    private SSLSocketFactory sslFactory = null;
    static String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    static String defaultKeyPass = "changeit";

    public JSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        Socket sslSocket = null;
        if (this.sslFactory == null) {
            this.initFactory();
        }
        if (port == -1) {
            port = 443;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("https");
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        if (tcp.getProxyHost().length() == 0 || hostInNonProxyList) {
            sslSocket = this.sslFactory.createSocket(host, port);
        } else {
            int tunnelPort;
            int n = tunnelPort = tcp.getProxyPort().length() != 0 ? Integer.parseInt(tcp.getProxyPort()) : 80;
            if (tunnelPort < 0) {
                tunnelPort = 80;
            }
            Socket tunnel = new Socket(tcp.getProxyHost(), tunnelPort);
            OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
            if (tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0) {
                String encodedPassword = XMLUtils.base64encode((tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            if (DefaultSocketFactory.log.isDebugEnabled()) {
                DefaultSocketFactory.log.debug((Object)Messages.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
            }
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while (newlinesSeen < 2) {
                int i = tunnelInputStream.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone) continue;
                replyStr = replyStr + String.valueOf((char)i);
            }
            if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
                throw new IOException(Messages.getMessage("cantTunnel00", new String[]{tcp.getProxyHost(), "" + tunnelPort, replyStr}));
            }
            sslSocket = this.sslFactory.createSocket(tunnel, host, port, true);
            if (DefaultSocketFactory.log.isDebugEnabled()) {
                DefaultSocketFactory.log.debug((Object)Messages.getMessage("setupTunnel00", tcp.getProxyHost(), "" + tunnelPort));
            }
        }
        ((SSLSocket)sslSocket).startHandshake();
        if (DefaultSocketFactory.log.isDebugEnabled()) {
            DefaultSocketFactory.log.debug((Object)Messages.getMessage("createdSSL00"));
        }
        return sslSocket;
    }

    private void initFactory() throws IOException {
        try {
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            if (this.attributes == null) {
                this.sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                SSLContext context = this.getContext();
                this.sslFactory = context.getSocketFactory();
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected SSLContext getContext() throws Exception {
        String algorithm;
        String protocol;
        String keystorePass;
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        this.keystoreType = (String)this.attributes.get("keystoreType");
        if (this.keystoreType == null) {
            this.keystoreType = defaultKeystoreType;
        }
        this.clientAuth = null != (String)this.attributes.get("clientauth");
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        if ((protocol = (String)this.attributes.get("protocol")) == null) {
            protocol = defaultProtocol;
        }
        if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
            algorithm = defaultAlgorithm;
        }
        KeyStore kstore = this.initKeyStore(keystoreFile, keystorePass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
        kmf.init(kstore, keyPass.toCharArray());
        TrustManager[] tm = null;
        if (this.clientAuth) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
            tmf.init(kstore);
            tm = tmf.getTrustManagers();
        }
        SSLContext context = SSLContext.getInstance((String)protocol);
        context.init(kmf.getKeyManagers(), tm, new SecureRandom());
        return context;
    }

    private KeyStore initKeyStore(String keystoreFile, String keyPass) throws IOException {
        try {
            KeyStore kstore = KeyStore.getInstance(this.keystoreType);
            FileInputStream istream = new FileInputStream(keystoreFile);
            kstore.load(istream, keyPass.toCharArray());
            return kstore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Exception trying to load keystore " + keystoreFile + ": " + ex.getMessage());
        }
    }
}

