/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.ObjectRegistry;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(node, sw);
        return sw.toString();
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOM2Writer.print(node, null, new PrintWriter(writer));
    }

    private static void print(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        if (node == null) {
            return;
        }
        boolean hasChildren = false;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\"?>");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int numChildren = children.getLength();
                int i = 0;
                while (i < numChildren) {
                    DOM2Writer.print(children.item(i), namespaceStack, out);
                    ++i;
                }
                break;
            }
            case 1: {
                NamedNodeMap attrs;
                namespaceStack = new ObjectRegistry(namespaceStack);
                out.print('<' + node.getNodeName());
                String elPrefix = node.getPrefix();
                String elNamespaceURI = node.getNamespaceURI();
                if (elPrefix != null && elNamespaceURI != null) {
                    boolean prefixIsDeclared = false;
                    try {
                        String namespaceURI = (String)namespaceStack.lookup(elPrefix);
                        if (elNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (!prefixIsDeclared) {
                        DOM2Writer.printNamespaceDecl(node, namespaceStack, out);
                    }
                }
                int len = (attrs = node.getAttributes()) != null ? attrs.getLength() : 0;
                int i = 0;
                while (i < len) {
                    Attr attr = (Attr)attrs.item(i);
                    out.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize(attr.getValue()) + '\"');
                    String attrPrefix = attr.getPrefix();
                    String attrNamespaceURI = attr.getNamespaceURI();
                    if (attrPrefix != null && attrNamespaceURI != null) {
                        boolean prefixIsDeclared = false;
                        try {
                            String namespaceURI = (String)namespaceStack.lookup(attrPrefix);
                            if (attrNamespaceURI.equals(namespaceURI)) {
                                prefixIsDeclared = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (!prefixIsDeclared) {
                            DOM2Writer.printNamespaceDecl(attr, namespaceStack, out);
                        }
                    }
                    ++i;
                }
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int numChildren = children.getLength();
                    boolean bl = hasChildren = numChildren > 0;
                    if (hasChildren) {
                        out.print('>');
                    }
                    int i2 = 0;
                    while (i2 < numChildren) {
                        DOM2Writer.print(children.item(i2), namespaceStack, out);
                        ++i2;
                    }
                } else {
                    hasChildren = false;
                }
                if (hasChildren) break;
                out.print("/>");
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                out.print("<!--");
                out.print(node.getNodeValue());
                out.print("-->");
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1 && hasChildren) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
            boolean bl = false;
        }
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, out);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, namespaceStack, out);
            }
        }
    }

    private static void printNamespaceDecl(Element owner, Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (!namespaceURI.equals(NS_URI_XMLNS) || !prefix.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(owner, NS_URI_XMLNS, prefix) == null) {
                out.print(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
            }
        } else {
            prefix = node.getLocalName();
            namespaceURI = node.getNodeValue();
        }
        namespaceStack.register(prefix, namespaceURI);
    }

    private static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(StringUtils.lineSeparator);
                            break;
                        }
                        str.append('\n');
                        break;
                    }
                    str.append(StringUtils.lineSeparator);
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

