/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.JavaProvider;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class RPCProvider
extends JavaProvider {
    private static final Log LOGGER = LogFactory.getLog(RPCProvider.class.getName());

    @Override
    public void processMessage(MessageContext messageContext, SOAPEnvelope sOAPEnvelope, SOAPEnvelope sOAPEnvelope2, Object object) throws Exception {
        RPCParam rPCParam;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: RPCProvider.processMessage()");
        }
        SOAPService sOAPService = messageContext.getService();
        ServiceDesc serviceDesc = sOAPService.getServiceDescription();
        OperationDesc operationDesc = messageContext.getOperation();
        Vector vector = sOAPEnvelope.getBodyElements();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("bodyElems00", "" + vector.size()));
            LOGGER.debug((Object)Messages.getMessage("bodyIs00", "" + vector.get(0)));
        }
        RPCElement rPCElement = null;
        for (int i = 0; rPCElement == null && i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof RPCElement)) {
                Object object5;
                object4 = (SOAPBodyElement)vector.get(i);
                if (!((MessageElement)object4).isRoot() || operationDesc == null || ((MessageElement)object4).getID() != null || (object5 = operationDesc.getParameter(i)) == null) continue;
                objectArray = ((MessageElement)object4).getValueAsType(((ParameterDesc)object5).getTypeQName());
                rPCElement = new RPCElement("", operationDesc.getName(), new Object[]{objectArray});
                continue;
            }
            rPCElement = (RPCElement)vector.get(i);
        }
        if (rPCElement == null) {
            if (!serviceDesc.getStyle().equals(Style.DOCUMENT)) {
                throw new Exception(Messages.getMessage("noBody00"));
            }
            ArrayList arrayList = serviceDesc.getOperations();
            for (Object object5 : arrayList) {
                if (((OperationDesc)object5).getNumInParams() != 0) continue;
                messageContext.setOperation((OperationDesc)object5);
                rPCElement = new RPCElement(((OperationDesc)object5).getName());
                break;
            }
            if (rPCElement == null) {
                throw new Exception(Messages.getMessage("noBody00"));
            }
        }
        String string = rPCElement.getMethodName();
        object4 = rPCElement.getParams();
        int n = ((Vector)object4).size();
        operationDesc = messageContext.getOperation();
        if (operationDesc == null) {
            objectArray = new QName(rPCElement.getNamespaceURI(), rPCElement.getName());
            operationDesc = serviceDesc.getOperationByElementQName((QName)objectArray);
        }
        if (operationDesc == null) {
            throw new AxisFault(Messages.getMessage("noSuchOperation", string));
        }
        objectArray = new Object[operationDesc.getNumParams()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            object3 = (RPCParam)((Vector)object4).get(i);
            Object object6 = ((RPCParam)object3).getValue();
            object2 = ((RPCParam)object3).getParamDesc();
            if (object2 != null && ((ParameterDesc)object2).getJavaType() != null) {
                Class serializable2 = ((ParameterDesc)object2).getJavaType();
                object6 = JavaUtils.convert(object6, serializable2);
                ((RPCParam)object3).setValue(object6);
                if (((ParameterDesc)object2).getMode() == 3) {
                    arrayList.add(object3);
                }
            }
            if (object2 == null || ((ParameterDesc)object2).getOrder() == -1) {
                objectArray[i] = object6;
            } else {
                objectArray[((ParameterDesc)object2).getOrder()] = object6;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("  " + Messages.getMessage("value00", "" + objectArray[i])));
        }
        String string2 = (String)sOAPService.getOption("allowedMethods");
        this.checkMethodName(messageContext, string2, operationDesc.getName());
        if (n < objectArray.length) {
            object3 = operationDesc.getOutParams();
            for (int i = 0; i < object3.size(); ++i) {
                object2 = (ParameterDesc)object3.get(i);
                Class clazz = ((ParameterDesc)object2).getJavaType();
                if (clazz == null || !Holder.class.isAssignableFrom(clazz)) {
                    throw new AxisFault(Messages.getMessage("badOutParameter00", "" + ((ParameterDesc)object2).getQName(), operationDesc.getName()));
                }
                objectArray[n + i] = clazz.newInstance();
                rPCParam = new RPCParam(((ParameterDesc)object2).getQName(), objectArray[n + i]);
                rPCParam.setParamDesc((ParameterDesc)object2);
                arrayList.add(rPCParam);
            }
        }
        object3 = null;
        try {
            object3 = this.invokeMethod(messageContext, operationDesc.getMethod(), object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object2 = operationDesc.getMethod().toString();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append(objectArray[i].getClass().getName());
                }
                if (i + 1 >= objectArray.length) continue;
                stringBuilder.append(",");
            }
            String string3 = stringBuilder.toString();
            LOGGER.info((Object)Messages.getMessage("dispatchIAE00", new String[]{object2, string3}), (Throwable)illegalArgumentException);
            throw new AxisFault(Messages.getMessage("dispatchIAE00", new String[]{object2, string3}), illegalArgumentException);
        }
        RPCElement rPCElement2 = new RPCElement(string + "Response");
        rPCElement2.setPrefix(rPCElement.getPrefix());
        rPCElement2.setNamespaceURI(rPCElement.getNamespaceURI());
        rPCElement2.setEncodingStyle(messageContext.getEncodingStyle());
        if (operationDesc.getMethod().getReturnType() != Void.TYPE) {
            object2 = operationDesc.getReturnQName();
            if (object2 == null) {
                object2 = new QName("", "return");
            }
            if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
                RPCParam rPCParam2 = new RPCParam(Constants.QNAME_RPC_RESULT, (Object)((QName)object2).getLocalPart());
                rPCElement2.addParam(rPCParam2);
            }
            RPCParam rPCParam3 = new RPCParam((QName)object2, object3);
            rPCParam3.setParamDesc(operationDesc.getReturnParamDesc());
            rPCElement2.addParam(rPCParam3);
        }
        if (!arrayList.isEmpty()) {
            for (RPCParam rPCParam4 : arrayList) {
                rPCParam = (Holder)rPCParam4.getValue();
                Object object5 = JavaUtils.getHolderValue(rPCParam);
                rPCParam4.setValue(object5);
                rPCElement2.addParam(rPCParam4);
            }
        }
        sOAPEnvelope2.addBodyElement(rPCElement2);
    }

    protected Object invokeMethod(MessageContext messageContext, Method method, Object object, Object[] objectArray) throws Exception {
        return method.invoke(object, objectArray);
    }

    protected void checkMethodName(MessageContext messageContext, String string, String string2) throws Exception {
    }
}

