//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.config.BaseData;
import org.apache.tools.ant.types.Reference;

/** <!-- ========================================================================================================== -->
* Base class for a task that references a {@link com.actional.config.BaseData}.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public abstract class RefTaskBase extends SOAPstationTaskBase
{
	protected BaseData	itsFound;
	protected boolean	itMustExists = true;

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	// Only one of the following should be set.
	protected Reference	itsRefid;
	protected String	itsName;
	
	public void setRefid(Reference val) 	{ itsRefid = val; }
	public void setName(String val) 	{ itsName = val; }

	/** <!-- ================================================================================================== -->
	* What type of BaseData class should we be referencing?
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected Class _getRefType()
	{
		return null;
	}

	/** <!-- ================================================================================================== -->
	* Get the BaseData that we will be searching for.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	
	protected BaseData _getBDToFind() throws Exception
	{
		BaseData bd = (BaseData)_getRefType().newInstance();

		bd.setKeyName(itsName);
		return bd;
	}

	/** <!-- ================================================================================================== -->
	* Locate the BaseData that we are referencing.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected BaseData locateBaseData() throws Exception
	{
		return doFind();
	}

	/** <!-- ================================================================================================== -->
	* Locate the KeyID of the BaseData that we are referencing.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected String locateBaseDataID() throws Exception
	{
		BaseData found = doFind();
		
		if (found == null)
			return null;
			
		return found.getKeyID();
	}
	
	protected BaseData doFind() throws Exception
	{
		if (itsName != null)
		{
			if (itMustExists)
				return _getConfig().findFirst(_getBDToFind());
			else
				return _getConfig().findFirstIfExists(_getBDToFind());
		}

		return locateBaseData(itsRefid);
	}
}
