//=====================================================================================================================
// Copyright (c) 2016-2018. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.server;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.rpc.ServiceException;

import com.actional.jetty.task.IUsersTask;
import com.actional.jetty.task.IUsersTaskServiceLocator;
import com.actional.soapapi.Config;
import com.actional.soapapi.SupportZipDownload;
import com.actional.soapstation.task.IActiveAgentTask;
import com.actional.soapstation.task.IActiveAgentTaskServiceLocator;
import com.actional.soapstation.task.IAgentConfigTask;
import com.actional.soapstation.task.IAgentConfigTaskServiceLocator;
import com.actional.soapstation.task.IBusinessProcessTask;
import com.actional.soapstation.task.IBusinessProcessTaskServiceLocator;
import com.actional.soapstation.task.IDBMaintenanceTask;
import com.actional.soapstation.task.IDBMaintenanceTaskServiceLocator;
import com.actional.soapstation.task.IDeploymentTask;
import com.actional.soapstation.task.IDeploymentTaskServiceLocator;
import com.actional.soapstation.task.IDimensionTask;
import com.actional.soapstation.task.IDimensionTaskServiceLocator;
import com.actional.soapstation.task.IEventLogTask;
import com.actional.soapstation.task.IEventLogTaskServiceLocator;
import com.actional.soapstation.task.IExportedArtifactsTask;
import com.actional.soapstation.task.IExportedArtifactsTaskServiceLocator;
import com.actional.soapstation.task.IFlowMapTask;
import com.actional.soapstation.task.IFlowMapTaskServiceLocator;
import com.actional.soapstation.task.IInitialSetupTask;
import com.actional.soapstation.task.IInitialSetupTaskServiceLocator;
import com.actional.soapstation.task.IJavaPlugInTask;
import com.actional.soapstation.task.IJavaPlugInTaskServiceLocator;
import com.actional.soapstation.task.ILGAlertTask;
import com.actional.soapstation.task.ILGAlertTaskServiceLocator;
import com.actional.soapstation.task.ILGCallSiteTask;
import com.actional.soapstation.task.ILGCallSiteTaskServiceLocator;
import com.actional.soapstation.task.ILGNetworkTask;
import com.actional.soapstation.task.ILGNetworkTaskServiceLocator;
import com.actional.soapstation.task.ILGPortalTask;
import com.actional.soapstation.task.ILGPortalTaskServiceLocator;
import com.actional.soapstation.task.ILicenseServerManagementTask;
import com.actional.soapstation.task.ILicenseServerManagementTaskServiceLocator;
import com.actional.soapstation.task.ILicenseTask;
import com.actional.soapstation.task.ILicenseTaskServiceLocator;
import com.actional.soapstation.task.ILoggingDatabaseTask;
import com.actional.soapstation.task.ILoggingDatabaseTaskServiceLocator;
import com.actional.soapstation.task.IMitigationInstanceTask;
import com.actional.soapstation.task.IMitigationInstanceTaskServiceLocator;
import com.actional.soapstation.task.IMsgFieldIDObjectAssignmentTask;
import com.actional.soapstation.task.IMsgFieldIDObjectAssignmentTaskServiceLocator;
import com.actional.soapstation.task.IMsgFieldSiteAssignmentTask;
import com.actional.soapstation.task.IMsgFieldSiteAssignmentTaskServiceLocator;
import com.actional.soapstation.task.IMsgFieldTask;
import com.actional.soapstation.task.IMsgFieldTaskServiceLocator;
import com.actional.soapstation.task.INetworkActivityTask;
import com.actional.soapstation.task.INetworkActivityTaskServiceLocator;
import com.actional.soapstation.task.INetworkMaintenanceTask;
import com.actional.soapstation.task.INetworkMaintenanceTaskServiceLocator;
import com.actional.soapstation.task.IPolicyGroupTask;
import com.actional.soapstation.task.IPolicyGroupTaskServiceLocator;
import com.actional.soapstation.task.IProfileTask;
import com.actional.soapstation.task.IProfileTaskServiceLocator;
import com.actional.soapstation.task.IRuleTask;
import com.actional.soapstation.task.IRuleTaskServiceLocator;
import com.actional.soapstation.task.IServer;
import com.actional.soapstation.task.IServerServiceLocator;
import com.actional.soapstation.task.IServerUserPreferencesTask;
import com.actional.soapstation.task.IServerUserPreferencesTaskServiceLocator;
import com.actional.soapstation.task.IServiceTask;
import com.actional.soapstation.task.IServiceTaskServiceLocator;
import com.actional.soapstation.task.ISiteCriteriaTask;
import com.actional.soapstation.task.ISiteCriteriaTaskServiceLocator;
import com.actional.soapstation.task.ITransportsTask;
import com.actional.soapstation.task.ITransportsTaskServiceLocator;
import com.actional.soapstation.task.IUserBDTask;
import com.actional.soapstation.task.IUserBDTaskServiceLocator;

/** <!-- ========================================================================================================== -->
 * This class provides typical services exposed by Actional Server.
 *
 * @lastrev fix41522 - including IServer
 * <!-- -------------------------------------------------------------------------------------------------------- --> */

public class ServerConfig extends Config
{
	/** <!-- ================================================================================================== -->
	* The Locators for the task services
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected IJavaPlugInTaskServiceLocator		javaPluginTaskLocator = new IJavaPlugInTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
											throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IUserBDTaskServiceLocator		userBDTaskServiceLocator = new IUserBDTaskServiceLocator()
							{
								public javax.xml.rpc.Call createCall()
										throws ServiceException
								{
									return prepareCall(super.createCall());
								}
							};

	protected IFlowMapTaskServiceLocator		flowMapTaskLocator = new IFlowMapTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
											throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ITransportsTaskServiceLocator		transportsTaskLocator = new ITransportsTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
											throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IAgentConfigTaskServiceLocator	agentConfigTaskLocator = new IAgentConfigTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILGCallSiteTaskServiceLocator		lgCallSiteTaskLocator = new ILGCallSiteTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};


	protected ILGPortalTaskServiceLocator		lgPortalTaskLocator = new ILGPortalTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILoggingDatabaseTaskServiceLocator		loggingDatabaseTaskLocator = new ILoggingDatabaseTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IMitigationInstanceTaskServiceLocator		mitigationInstanceTaskLocator = new IMitigationInstanceTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILicenseServerManagementTaskServiceLocator	licenseManagementTaskLocator = new ILicenseServerManagementTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILicenseTaskServiceLocator	licenseTaskLocator = new ILicenseTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILGAlertTaskServiceLocator	lgAlertTaskLocator = new ILGAlertTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IProfileTaskServiceLocator	profileTaskLocator = new IProfileTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IRuleTaskServiceLocator	ruleTaskLocator = new IRuleTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IActiveAgentTaskServiceLocator	activeAgentTaskLocator = new IActiveAgentTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IUsersTaskServiceLocator	usersTaskLocator = new IUsersTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IInitialSetupTaskServiceLocator	initialSetupTaskLocator = new IInitialSetupTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IBusinessProcessTaskServiceLocator	bpTaskLocator = new IBusinessProcessTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IPolicyGroupTaskServiceLocator	policyGroupTaskLocator = new IPolicyGroupTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IDeploymentTaskServiceLocator	deploymentTaskLocator = new IDeploymentTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IDimensionTaskServiceLocator	dimensionTaskLocator = new IDimensionTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected INetworkActivityTaskServiceLocator	networkActivityTaskLocator = new INetworkActivityTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IMsgFieldTaskServiceLocator	msgFieldTaskLocator = new IMsgFieldTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IMsgFieldSiteAssignmentTaskServiceLocator msgFieldSiteAssignmentTaskLocator = new IMsgFieldSiteAssignmentTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IMsgFieldIDObjectAssignmentTaskServiceLocator msgFieldIDObjectAssignmentTaskLocator = new IMsgFieldIDObjectAssignmentTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IEventLogTaskServiceLocator	eventLogTaskLocator = new IEventLogTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ISiteCriteriaTaskServiceLocator	siteCriteriaTaskLocator = new ISiteCriteriaTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IServiceTaskServiceLocator	serviceTaskLocator = new IServiceTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IDBMaintenanceTaskServiceLocator	dbMaintenanceTaskLocator = new IDBMaintenanceTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected ILGNetworkTaskServiceLocator	lgNetworkTaskLocator = new ILGNetworkTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected INetworkMaintenanceTaskServiceLocator	networkMaintenanceTaskLocator = new INetworkMaintenanceTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IServerUserPreferencesTaskServiceLocator	serverUserPreferencesTaskLocator = new IServerUserPreferencesTaskServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IServerServiceLocator	serverTaskLocator = new IServerServiceLocator()
								{
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IExportedArtifactsTaskServiceLocator	exportedArtifactsTaskLocator = new IExportedArtifactsTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	/** <!-- ================================================================================================== -->
	* The Tasks
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public IAgentConfigTask			agentConfigTask;
	public ILGCallSiteTask			lgCallSiteTask;
	public ILGPortalTask			lgPortalTask;
	public ILoggingDatabaseTask		loggingDatabaseTask;
	public IMitigationInstanceTask		mitigationInstanceTask;
	public ILicenseServerManagementTask	licenseManagementTask;
	public ILicenseTask			licenseTask;
	public ILGAlertTask			lgAlertTask;
	public IProfileTask			profileTask;
	public IRuleTask			ruleTask;
	public IActiveAgentTask			activeAgentTask;
	public IUsersTask			usersTask;
	public IUserBDTask			userBDTask;
	public IInitialSetupTask		initialSetupTask;
	public IBusinessProcessTask		bpTask;
	public IPolicyGroupTask			policyGroupTask;
	public IDeploymentTask			deploymentTask;
	public IDimensionTask			dimensionTask;
	public INetworkActivityTask		networkActivityTask;
	public IMsgFieldTask			msgFieldTask;
	public IMsgFieldSiteAssignmentTask	msgFieldSiteAssignmentTask;
	public IMsgFieldIDObjectAssignmentTask	msgFieldIDObjectAssignmentTask;
	public IEventLogTask			eventLogTask;
	public ISiteCriteriaTask		siteCriteriaTask;
	public IServiceTask			serviceTask;
	public IJavaPlugInTask			javaPluginTask;
	public IFlowMapTask			flowMapTask;
	public ITransportsTask			transportsTask;
	public IDBMaintenanceTask		dbMaintenanceTask;
	public ILGNetworkTask			lgNetworkTask;
	public INetworkMaintenanceTask		networkMaintenanceTask;
	public IServerUserPreferencesTask	serverUserPreferencesTask;
	public IServer				serverTask;
	public IExportedArtifactsTask		exportedArtifactsTask;

	protected Map<Class<? extends ServerTask>, ServerTask> itsTaskCache =
		new HashMap<Class<? extends ServerTask>, ServerTask>();

	/** <!-- ================================================================================================== -->
	 * The default configuration to use when talking to the server.
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	protected static ServerConfig	itsDefaultConfig;

	public static synchronized ServerConfig getDefaultConfig()
	{
		return itsDefaultConfig;
	}

	public static synchronized void	setDefaultConfig(final ServerConfig config)
	{
		itsDefaultConfig = config;
	}

	public static synchronized boolean setDefaultConfigIfNotSet(final ServerConfig config)
	{
		if (itsDefaultConfig == null)
		{
			itsDefaultConfig = config;
			return true;
		}
		else
			return false;
	}

	/** <!-- ================================================================================================== -->
	 * Constructor
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	public ServerConfig()
	{
		// Use the default configuration.
		super(null, null, null);
	}

	public ServerConfig(final String userName, final String password, final String endpoint)
	{
		super(userName, password, endpoint);
	}

	/** <!-- ================================================================================================== -->
	 * Initialize the axis stubs.
	 *
	 * @lastrev fix41522 - including IServer
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	@Override
	protected void prepareTasks()
		throws ServiceException, MalformedURLException
	{
		super.prepareTasks();

		agentConfigTask	= agentConfigTaskLocator.getIAgentConfigTask(	proxyUrl(agentConfigTaskLocator.getIAgentConfigTaskAddress()) );
		lgCallSiteTask	= lgCallSiteTaskLocator.getILGCallSiteTask(	proxyUrl(lgCallSiteTaskLocator.getILGCallSiteTaskAddress()) );
		lgPortalTask	= lgPortalTaskLocator.getILGPortalTask(		proxyUrl(lgPortalTaskLocator.getILGPortalTaskAddress()) );
		loggingDatabaseTask	= loggingDatabaseTaskLocator.getILoggingDatabaseTask(	proxyUrl(loggingDatabaseTaskLocator.getILoggingDatabaseTaskAddress()) );
		mitigationInstanceTask	= mitigationInstanceTaskLocator.getIMitigationInstanceTask(proxyUrl(mitigationInstanceTaskLocator.getIMitigationInstanceTaskAddress()) );
		licenseManagementTask = licenseManagementTaskLocator.getILicenseServerManagementTask(proxyUrl(licenseManagementTaskLocator.getILicenseServerManagementTaskAddress()));
		licenseTask = licenseTaskLocator.getILicenseTask(proxyUrl(licenseTaskLocator.getILicenseTaskAddress()));
		lgAlertTask = lgAlertTaskLocator.getILGAlertTask(proxyUrl(lgAlertTaskLocator.getILGAlertTaskAddress()));
		profileTask = profileTaskLocator.getIProfileTask(proxyUrl(profileTaskLocator.getIProfileTaskAddress()));
		ruleTask = ruleTaskLocator.getIRuleTask(proxyUrl(ruleTaskLocator.getIRuleTaskAddress()));
		activeAgentTask = activeAgentTaskLocator.getIActiveAgentTask(proxyUrl(activeAgentTaskLocator.getIActiveAgentTaskAddress()));
		usersTask = usersTaskLocator.getIUsersTask(proxyUrl(usersTaskLocator.getIUsersTaskAddress()));
		userBDTask = userBDTaskServiceLocator.getIUserBDTask(proxyUrl(userBDTaskServiceLocator.getIUserBDTaskAddress()));
		initialSetupTask = initialSetupTaskLocator.getIInitialSetupTask(proxyUrl(initialSetupTaskLocator.getIInitialSetupTaskAddress()));
		bpTask = bpTaskLocator.getIBusinessProcessTask(proxyUrl(bpTaskLocator.getIBusinessProcessTaskAddress()));
		policyGroupTask = policyGroupTaskLocator.getIPolicyGroupTask(proxyUrl(policyGroupTaskLocator.getIPolicyGroupTaskAddress()));
		deploymentTask = deploymentTaskLocator.getIDeploymentTask(proxyUrl(deploymentTaskLocator.getIDeploymentTaskAddress()));
		dimensionTask = dimensionTaskLocator.getIDimensionTask(proxyUrl(dimensionTaskLocator.getIDimensionTaskAddress()));
		msgFieldTask = msgFieldTaskLocator.getIMsgFieldTask(proxyUrl(msgFieldTaskLocator.getIMsgFieldTaskAddress()));
		msgFieldSiteAssignmentTask = msgFieldSiteAssignmentTaskLocator.getIMsgFieldSiteAssignmentTask(proxyUrl(msgFieldSiteAssignmentTaskLocator.getIMsgFieldSiteAssignmentTaskAddress()));
		msgFieldIDObjectAssignmentTask = msgFieldIDObjectAssignmentTaskLocator.getIMsgFieldIDObjectAssignmentTask(proxyUrl(msgFieldIDObjectAssignmentTaskLocator.getIMsgFieldIDObjectAssignmentTaskAddress()));
		networkActivityTask = networkActivityTaskLocator.getINetworkActivityTask(proxyUrl(networkActivityTaskLocator.getINetworkActivityTaskAddress()));
		eventLogTask	= eventLogTaskLocator.getIEventLogTask(proxyUrl(eventLogTaskLocator.getIEventLogTaskAddress()));
		siteCriteriaTask = siteCriteriaTaskLocator.getISiteCriteriaTask(proxyUrl(siteCriteriaTaskLocator.getISiteCriteriaTaskAddress()));
		serviceTask	= serviceTaskLocator.getIServiceTask(proxyUrl(serviceTaskLocator.getIServiceTaskAddress()));
		javaPluginTask = javaPluginTaskLocator.getIJavaPlugInTask(proxyUrl(javaPluginTaskLocator.getIJavaPlugInTaskAddress()));
		flowMapTask = flowMapTaskLocator.getIFlowMapTask(proxyUrl(flowMapTaskLocator.getIFlowMapTaskAddress()));
		transportsTask	= transportsTaskLocator.getITransportsTask(proxyUrl(transportsTaskLocator.getITransportsTaskAddress()));
		dbMaintenanceTask = dbMaintenanceTaskLocator.getIDBMaintenanceTask(proxyUrl(dbMaintenanceTaskLocator.getIDBMaintenanceTaskAddress()));
		lgNetworkTask = lgNetworkTaskLocator.getILGNetworkTask(proxyUrl(lgNetworkTaskLocator.getILGNetworkTaskAddress()));
		networkMaintenanceTask = networkMaintenanceTaskLocator.getINetworkMaintenanceTask(proxyUrl(networkMaintenanceTaskLocator.getINetworkMaintenanceTaskAddress()));
		serverUserPreferencesTask = serverUserPreferencesTaskLocator.getIServerUserPreferencesTask(proxyUrl(serverUserPreferencesTaskLocator.getIServerUserPreferencesTaskAddress()));
		serverTask = serverTaskLocator.getIServer(proxyUrl(serverTaskLocator.getIServerAddress()));
		exportedArtifactsTask = exportedArtifactsTaskLocator.getIExportedArtifactsTask(	proxyUrl(exportedArtifactsTaskLocator.getIExportedArtifactsTaskAddress()));

		prepareStub(agentConfigTask);
		prepareStub(lgCallSiteTask);
		prepareStub(lgPortalTask);
		prepareStub(loggingDatabaseTask);
		prepareStub(mitigationInstanceTask);
		prepareStub(licenseManagementTask);
		prepareStub(licenseTask);
		prepareStub(lgAlertTask);
		prepareStub(profileTask);
		prepareStub(ruleTask);
		prepareStub(activeAgentTask);
		prepareStub(usersTask);
		prepareStub(userBDTask);
		prepareStub(initialSetupTask);
		prepareStub(bpTask);
		prepareStub(policyGroupTask);
		prepareStub(deploymentTask);
		prepareStub(dimensionTask);
		prepareStub(msgFieldTask);
		prepareStub(msgFieldSiteAssignmentTask);
		prepareStub(msgFieldIDObjectAssignmentTask);
		prepareStub(networkActivityTask);
		prepareStub(eventLogTask);
		prepareStub(siteCriteriaTask);
		prepareStub(serviceTask);
		prepareStub(javaPluginTask);
		prepareStub(flowMapTask);
		prepareStub(transportsTask);
		prepareStub(dbMaintenanceTask);
		prepareStub(lgNetworkTask);
		prepareStub(networkMaintenanceTask);
		prepareStub(serverUserPreferencesTask);
		prepareStub(serverTask);
		prepareStub(exportedArtifactsTask);
	}

	/** <!-- ================================================================================================== -->
	* Prepare the task in the SDK. These are tasks on the client side to simplify server operations.
	*
	* @param taskClass	Subclass of ServerTask
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public synchronized ServerTask createTask(final Class<? extends ServerTask> taskClass) throws Exception
	{
		ServerTask task = itsTaskCache.get(taskClass);

		if (task != null)
			return task;

		try
		{
			task = taskClass.newInstance();
			task.setConfig(this);
			itsTaskCache.put(taskClass, task);

			return task;
		}
		catch (final Exception e)
		{
			throw new Exception("Failed to instantiate class: " + taskClass.getName(), e);
		}
	}

	/** <!-- ================================================================================================== -->
	 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	public SupportZipDownload newSupportZipCtx()
	{
		return new SupportZipDownload(itsEndpoint, itsUserName, itsPassword).withDeleteAgentEventFiles(true);
	}
}
