//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapapi.soapstation.SSTConfig;

/** <!-- ========================================================================================================== -->
* Connect to the specified SOAPstation.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class SOAPstationTask extends SOAPstationTaskBase
{
	private SSTConfig itsSSTConfig;
	
	public SSTConfig getConfig()
	{
		return itsSSTConfig;
	}
	
	public static SSTConfig getDefaultConfig()
	{
		return SSTConfig.getDefaultConfig();
	}

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	private String itsUsername;
	private String itsPassword;
	private String itsEndpoint;
	
	public void setUsername(String val)		{ itsUsername = val; }
	public void setPassword(String val)		{ itsPassword = val; }
	public void setEndpoint(String val)		{ itsEndpoint = val; }
	
	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	@Override
	public void executeEx() throws Exception
	{
		itsSSTConfig = new SSTConfig(itsUsername, itsPassword, itsEndpoint);
		itsSSTConfig.init();
		SSTConfig.setDefaultConfigIfNotSet(itsSSTConfig);
	}
}

