//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.config.BaseData;
import com.actional.soapapi.anttask.IBaseData;

/** <!-- ========================================================================================================== -->
* Base class for finding the first {@link com.actional.config.BaseData} which meets the criteria.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public abstract class FindFirstTask extends SOAPstationTaskBase implements IBaseData
{
	private BaseData itsFound;
	
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================
	
	protected abstract BaseData toFind();

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public void executeEx() throws Exception
	{
		BaseData bd = toFind();

		itsFound = _getConfig().findFirst(bd);
		
		log("Found " + bd.getClass().getName() + " '" +
			itsFound.getKeyName() +
			"' KeyID: " + getKeyID());
	}
	
	/** <!-- ================================================================================================== -->
	* IBaseData interface
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	
	public String getKeyID()
	{
		if (itsFound == null)
			return null;
		
		return itsFound.getKeyID();
	}

	public BaseData getBaseData()
	{
		return itsFound;
	}
}

