//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.actional.soapapi.Util;
import com.actional.soapapi.soapstation.DeploymentTask;
import com.actional.soapstation.db.ExportItem;

/** <!-- ========================================================================================================== -->
* Import one or more deployment files.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class ExportConfigTask extends SOAPstationTaskBase
{
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	/** List of ExportItemType */
	protected List	itsExportItems;
	protected File	itsOutputDir;

	public void setOutputDir(File val)		{ itsOutputDir = val; }
	public void addExport(ExportItemType val)	{ itsExportItems.add(val); }

	public ExportConfigTask()
	{
		itsExportItems = new ArrayList();
	}

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	@Override
	public void executeEx() throws Exception
	{
		if (Util.isBlank(itsExportItems))
		{
			log("No configuration has been specified for export.");
			return;
		}

		List exportItems = new ArrayList();

		for (int i = 0; i < itsExportItems.size(); i++)
		{
			ExportItemType exportItemType = (ExportItemType)itsExportItems.get(i);

			exportItemType.populate(_getSSTConfig(), exportItems);
		}

		ExportItem[] toExport = (ExportItem[])exportItems.toArray(new ExportItem[exportItems.size()]);

		DeploymentTask	deployTask = (DeploymentTask)createTask(DeploymentTask.class);
		String fileNames = deployTask.export(toExport, itsOutputDir);

		if (fileNames == null)
			log("No configuration has been exported");
		else
			log("Successfully exported the configuration to the following file(s): " + fileNames);
	}
}
