//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask;

import com.actional.config.BaseData;
import com.actional.soapapi.Config;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import java.rmi.RemoteException;

/** <!-- ========================================================================================================== -->
* Base class for actional ant tasks.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class TaskBase extends Task
{
	/** <!-- ================================================================================================== -->
	* Execute the ant task. The default implementation of this method is to call {@link #executeEx()}
	* and wrap any exception in a {@link BuildException}
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public void execute() throws BuildException
	{
		try
		{
			executeEx();
		}
		catch (Exception e)
		{
			throw new BuildException(e);
		}
	}
	
	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	protected void executeEx() throws Exception
	{
	}
	
	/** <!-- ================================================================================================== -->
	* Retrieve the IBaseDataKeyID in ref and return the keyID.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	protected String locateBaseDataID(Reference ref)
	{
		return locateBaseDataID(getProject(), ref);
	}

	public static String locateBaseDataID(Project project, Reference ref)
	{
		if (ref == null)
			return null;

		IBaseDataKeyID baseDataRef = (IBaseDataKeyID)ref.getReferencedObject(project);
		
		if (baseDataRef == null)
			return null;
		
		return baseDataRef.getKeyID();
	}

	/** <!-- ================================================================================================== -->
	* Retrieve the IBaseDataKeyID in ref and return the keyID.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	protected BaseData locateBaseData(Reference ref) throws RemoteException
	{
		return locateBaseData(getProject(), _getConfig(), ref);
	}

	public static BaseData locateBaseData(Project project, Config config, Reference ref) throws RemoteException
	{
		String keyID = locateBaseDataID(project, ref);
		
		if (keyID == null)
			return null;
		
		return config.configTask.get(keyID);
	}

	/** <!-- ================================================================================================== -->
	* Locate the configuration to use when talking to the server.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	protected Config _getConfig()
	{
		return null;
	}
}
