/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.javaClient;

import com.actional.soapapi.Util;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Input {
    private static final Logger LOGGER = Logger.getLogger(Input.class.getName());

    private Input() {
    }

    protected static int readInteger(String string, Integer n) throws Exception {
        while (true) {
            String string2 = Input.read(string, false, n == null ? null : n.toString());
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println("Invalid integer: " + exception);
                continue;
            }
            break;
        }
    }

    protected static boolean readBoolean(String string, Boolean bl) throws Exception {
        while (true) {
            String string2 = Input.read(string, false, bl == null ? null : bl.toString());
            try {
                return Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                System.out.println("Invalid boolean: " + exception);
                continue;
            }
            break;
        }
    }

    protected static String[] readStrings(String string, String string2) throws Exception {
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        while (!Util.isBlank((String)(string3 = Input.read(string, bl ? string2 : "")))) {
            bl = false;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static String read(String string) throws Exception {
        return Input.read(string, false, null);
    }

    protected static String read(String string, String string2) throws Exception {
        return Input.read(string, false, string2);
    }

    protected static String read(String string, boolean bl) throws Exception {
        return Input.read(string, bl, null);
    }

    protected static String read(String string, boolean bl, String string2) throws Exception {
        String string3;
        if (string2 != null && string2.length() > 0) {
            string3 = bl ? "*****" : string2;
            string = string + " (" + string3 + "): ";
        } else {
            string = string + ": ";
        }
        string3 = Input.doRead(string, bl);
        if ((string3 == null || string3.length() == 0) && string2 != null) {
            return string2;
        }
        return string3;
    }

    protected static String doRead(String string, boolean bl) throws Exception {
        String string2 = "";
        MaskingThread maskingThread = null;
        if (bl) {
            maskingThread = new MaskingThread(string);
            maskingThread.start();
        }
        System.out.print(string);
        while (true) {
            char c = (char)System.in.read();
            if (bl) {
                maskingThread.stopMasking();
                maskingThread.join();
                System.out.print("\r                     \r");
            }
            if (c == '\r') {
                c = (char)System.in.read();
                if (c != '\n') continue;
                break;
            }
            if (c == '\n') break;
            string2 = string2 + c;
        }
        return string2;
    }

    protected static class MaskingThread
    extends Thread {
        private boolean stop = false;
        private int index;
        private String prompt;

        public MaskingThread(String string) {
            this.prompt = string;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.SEVERE, interruptedException.getMessage(), interruptedException);
                }
                if (!this.stop) {
                    System.out.print("\r" + this.prompt + "              \r" + this.prompt);
                }
                System.out.flush();
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

