/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.server;

import com.actional.config.BaseData;
import com.actional.lg.db.AgentConfig;
import com.actional.lg.db.LGNode;
import com.actional.lg.server.broker.ProvisionInput;
import com.actional.soapapi.Util;
import com.actional.soapapi.server.ServerTask;
import com.actional.task.to.ProcessingMsgTO;
import com.actional.task.type.ProcessingMsgType;

public class AgentConfigTask
extends ServerTask {
    public static final Integer AGENT_TUNNING_PROCESS_ALL = new Integer(0);
    public static final Integer AGENT_TUNNING_OVERFLOW_DISCARD = new Integer(7168);

    public String locateAgentID(String string) throws Exception {
        AgentConfig agentConfig = new AgentConfig();
        LGNode[] lGNodeArray = new LGNode[1];
        LGNode lGNode = new LGNode();
        lGNode.setKeyName(string);
        lGNode.setIsFlowMap(Boolean.FALSE);
        lGNodeArray[0] = lGNode;
        agentConfig.setLGNodes(lGNodeArray);
        Object[] objectArray = this.config().configTask.findAllKeys((BaseData)agentConfig);
        int n = Util.length(objectArray);
        if (n == 0) {
            throw new Exception("Failed to locate node with name: " + string);
        }
        if (n > 1) {
            throw new Exception("Multiple nodes with the same name.");
        }
        Object object = objectArray[0];
        this.log().debug(1, "Found agent ID: " + (String)object);
        return object;
    }

    public LGNode locateNode(String string) throws Exception {
        LGNode lGNode = new LGNode();
        lGNode.setKeyName(string);
        lGNode.setIsFlowMap(Boolean.FALSE);
        Object[] objectArray = this.config().configTask.find((BaseData)lGNode);
        int n = Util.length(objectArray);
        if (n > 1) {
            throw new Exception("There are multiple matching nodes.");
        }
        if (n == 1) {
            lGNode = (LGNode)objectArray[0];
            this.log().debug(1, "Found node ID: " + lGNode.getKeyID());
            return lGNode;
        }
        return null;
    }

    public boolean isManaged(LGNode lGNode) throws Exception {
        return lGNode.getIsManaged();
    }

    public boolean provisionAgent(String string) throws Exception {
        if (string == null) {
            this.log().debug(1, "Agent to provision could not be found.");
            return false;
        }
        ProvisionInput provisionInput = new ProvisionInput();
        provisionInput.setMemberIDs(new String[]{string});
        provisionInput.setCompletionTimeout(20000L);
        this.config().activeAgentTask.provision(provisionInput);
        return true;
    }

    public boolean checkNodes() throws Exception {
        this.log().info("Checking all nodes for configuration problems...");
        ProcessingMsgTO processingMsgTO = this.config().lgCallSiteTask.checkNodes(null);
        if (processingMsgTO.getSeverity() == ProcessingMsgType.OK) {
            this.log().info("PASSED");
            return true;
        }
        this.log().info("FAILED: " + processingMsgTO.getMessage());
        int n = Util.length(processingMsgTO.getDetails());
        for (int i = 0; i < n; ++i) {
            ProcessingMsgTO processingMsgTO2 = processingMsgTO.getDetails()[i];
            this.log().info(1, processingMsgTO2.getSeverity() + " " + processingMsgTO2.getMessage());
        }
        return false;
    }
}

