/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.i18n.Messages;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.JavaProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MsgProvider
extends JavaProvider {
    public void processMessage(MessageContext msgContext, SOAPEnvelope reqEnv, SOAPEnvelope resEnv, Object obj) throws Exception {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null) {
            throw new AxisFault(Messages.getMessage("noOperationForQName", reqEnv.getFirstBody().getQName().toString()));
        }
        Method method = operation.getMethod();
        int methodType = operation.getMessageOperationStyle();
        if (methodType != 2) {
            Vector bodies = reqEnv.getBodyElements();
            Object[] argObjects = new Object[1];
            switch (methodType) {
                case 1: {
                    SOAPBodyElement[] bodyElements = new SOAPBodyElement[bodies.size()];
                    bodies.toArray(bodyElements);
                    argObjects[0] = bodyElements;
                    SOAPBodyElement[] bodyResult = (SOAPBodyElement[])method.invoke(obj, argObjects);
                    if (bodyResult != null) {
                        int i = 0;
                        while (i < bodyResult.length) {
                            SOAPBodyElement bodyElement = bodyResult[i];
                            resEnv.addBodyElement(bodyElement);
                            ++i;
                        }
                    }
                    return;
                }
                case 3: {
                    Element[] elements = new Element[bodies.size()];
                    int i = 0;
                    while (i < elements.length) {
                        SOAPBodyElement body = (SOAPBodyElement)bodies.get(i);
                        elements[i] = body.getAsDOM();
                        ++i;
                    }
                    argObjects[0] = elements;
                    Element[] elemResult = (Element[])method.invoke(obj, argObjects);
                    if (elemResult != null) {
                        int i2 = 0;
                        while (i2 < elemResult.length) {
                            if (elemResult[i2] != null) {
                                resEnv.addBodyElement(new SOAPBodyElement(elemResult[i2]));
                            }
                            ++i2;
                        }
                    }
                    return;
                }
                case 4: {
                    Document doc = ((SOAPBodyElement)bodies.get(0)).getAsDocument();
                    argObjects[0] = doc;
                    Document resultDoc = (Document)method.invoke(obj, argObjects);
                    if (resultDoc != null) {
                        resEnv.addBodyElement(new SOAPBodyElement(resultDoc.getDocumentElement()));
                    }
                    return;
                }
            }
        } else {
            Object[] argObjects = new Object[]{reqEnv, resEnv};
            method.invoke(obj, argObjects);
            return;
        }
        throw new AxisFault(Messages.getMessage("badMsgMethodStyle"));
    }
}

