/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    private static final Log LOGGER = LogFactory.getLog(BeanSerializer.class.getName());
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected TypeDesc typeDesc = null;

    public BeanSerializer(Class clazz, QName qName) {
        this(clazz, qName, TypeDesc.getTypeDescForClass(clazz));
    }

    public BeanSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this(clazz, qName, typeDesc, null);
        this.propertyDescriptor = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(clazz, null);
    }

    public BeanSerializer(Class clazz, QName qName, TypeDesc typeDesc, BeanPropertyDescriptor[] beanPropertyDescriptorArray) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = beanPropertyDescriptorArray != null && beanPropertyDescriptorArray.length > 0 ? (BeanPropertyDescriptor[])beanPropertyDescriptorArray.clone() : beanPropertyDescriptorArray;
    }

    @Override
    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        boolean bl;
        Attributes attributes2 = this.getObjectAttributes(object, attributes, serializationContext);
        String string = serializationContext.getMessageContext().getEncodingStyle();
        boolean bl2 = Constants.isSOAP_ENC(string);
        boolean bl3 = bl = !serializationContext.getMessageContext().isEncoded() && "".equals(qName.getNamespaceURI()) && "any".equals(qName.getLocalPart());
        if (!bl) {
            serializationContext.startElement(qName, attributes2);
        }
        try {
            BeanPropertyDescriptor beanPropertyDescriptor;
            Object object2;
            Object object3;
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object4;
                object3 = this.propertyDescriptor[i].getName();
                if ("class".equals(object3)) continue;
                object2 = null;
                QName qName2 = null;
                boolean bl4 = false;
                if (this.typeDesc != null && (object4 = this.typeDesc.getFieldByName((String)object3)) != null) {
                    if (!((FieldDesc)object4).isElement()) continue;
                    object2 = bl2 ? new QName(((FieldDesc)object4).getXmlName().getLocalPart()) : ((FieldDesc)object4).getXmlName();
                    bl4 = ((FieldDesc)object4).isMinOccursIs0();
                    qName2 = ((FieldDesc)object4).getXmlType();
                }
                if (object2 == null) {
                    object2 = new QName("", (String)object3);
                }
                if (qName2 == null) {
                    qName2 = serializationContext.getQNameForClass(this.propertyDescriptor[i].getType());
                }
                if (!this.propertyDescriptor[i].isReadable()) continue;
                if (!this.propertyDescriptor[i].isIndexed()) {
                    object4 = this.propertyDescriptor[i].get(object);
                    if (object4 == null && bl4 && !bl2) continue;
                    serializationContext.serialize((QName)object2, null, object4, qName2, true, null);
                    continue;
                }
                int n = 0;
                while (n >= 0) {
                    Object object5 = null;
                    try {
                        object5 = this.propertyDescriptor[i].get(object, n);
                        ++n;
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                    if (n < 0) continue;
                    serializationContext.serialize((QName)object2, null, object5, qName2, true, null);
                }
            }
            BeanPropertyDescriptor beanPropertyDescriptor2 = beanPropertyDescriptor = this.typeDesc == null ? null : this.typeDesc.getAnyDesc();
            if (beanPropertyDescriptor != null && (object3 = beanPropertyDescriptor.get(object)) != null && object3 instanceof MessageElement[]) {
                object2 = (MessageElement[])object3;
                for (int i = 0; i < ((MessageElement[])object2).length; ++i) {
                    MessageElement messageElement = object2[i];
                    messageElement.output(serializationContext);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            LOGGER.error((Object)Messages.getMessage("exception00"), throwable);
            throw new IOException(throwable.toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            throw new IOException(exception.toString());
        }
        if (!bl) {
            serializationContext.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    @Override
    public boolean writeSchema(Types types) throws Exception {
        Object object;
        Object object2;
        Element element = types.createElement("complexType");
        types.writeSchemaElement(this.xmlType, element);
        element.setAttribute("name", this.xmlType.getLocalPart());
        Object object3 = null;
        Class clazz = this.javaType.getSuperclass();
        BeanPropertyDescriptor[] beanPropertyDescriptorArray = null;
        List list = types.getStopClasses();
        if (!(clazz == null || clazz == Object.class || clazz == Exception.class || clazz == Throwable.class || clazz == RemoteException.class || clazz == AxisFault.class || list != null && list.contains(clazz.getName()))) {
            object2 = types.writeType(clazz);
            Element element2 = types.createElement("complexContent");
            element.appendChild(element2);
            object = types.createElement("extension");
            element2.appendChild((Node)object);
            object.setAttribute("base", (String)object2);
            object3 = object;
            TypeDesc typeDesc = TypeDesc.getTypeDescForClass(clazz);
            beanPropertyDescriptorArray = typeDesc != null ? this.typeDesc.getPropertyDescriptors() : BeanUtils.getPd(clazz, null);
        } else {
            object3 = element;
        }
        object2 = types.createElement("sequence");
        object3.appendChild((Node)object2);
        if (Modifier.isAbstract(this.javaType.getModifiers())) {
            element.setAttribute("abstract", "true");
        }
        for (int i = 0; i < this.propertyDescriptor.length; ++i) {
            object = this.propertyDescriptor[i].getName();
            boolean bl = true;
            if ("class".equals(object)) {
                bl = false;
            }
            if (beanPropertyDescriptorArray != null && bl) {
                for (int j = 0; j < beanPropertyDescriptorArray.length && bl; ++j) {
                    if (!((String)object).equals(beanPropertyDescriptorArray[j].getName())) continue;
                    bl = false;
                }
            }
            if (!bl || !this.propertyDescriptor[i].isReadable()) continue;
            if (this.typeDesc != null) {
                FieldDesc fieldDesc = this.typeDesc.getFieldByName((String)object);
                if (fieldDesc != null) {
                    QName qName = fieldDesc.getXmlName();
                    if (qName != null) {
                        object = qName.getLocalPart();
                    }
                    if (!fieldDesc.isElement()) {
                        this.writeAttribute(types, (String)object, this.propertyDescriptor[i].getType(), element);
                        continue;
                    }
                    this.writeField(types, (String)object, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), fieldDesc.isMinOccursIs0(), (Element)object2);
                    continue;
                }
                this.writeField(types, (String)object, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, (Element)object2);
                continue;
            }
            this.writeField(types, (String)object, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, (Element)object2);
        }
        return true;
    }

    protected void writeField(Types types, String string, Class clazz, boolean bl, boolean bl2, Element element) throws Exception {
        Object object;
        String string2 = types.writeType(clazz);
        if (string2 == null) {
            object = Constants.XSD_ANYTYPE;
            String string3 = types.getNamespaces().getCreatePrefix(((QName)object).getNamespaceURI());
            string2 = string3 + ":" + ((QName)object).getLocalPart();
        }
        object = types.createElement(string, string2, types.isNullable(clazz), bl2, element.getOwnerDocument());
        if (bl) {
            object.setAttribute("maxOccurs", "unbounded");
        }
        element.appendChild((Node)object);
    }

    protected void writeAttribute(Types types, String string, Class clazz, Element element) throws Exception {
        if (!types.isAcceptableAsAttribute(clazz)) {
            throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", string, clazz.getName()));
        }
        String string2 = types.writeType(clazz);
        Element element2 = types.createAttributeElement(string, string2, false, element.getOwnerDocument());
        element.appendChild(element2);
    }

    protected Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object2;
                FieldDesc fieldDesc;
                String string = this.propertyDescriptor[i].getName();
                if ("class".equals(string) || (fieldDesc = this.typeDesc.getFieldByName(string)) == null || fieldDesc.isElement()) continue;
                QName qName = fieldDesc.getXmlName();
                if (qName == null) {
                    qName = new QName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (object2 = this.propertyDescriptor[i].get(object)) == null) continue;
                this.setAttributeProperty(object2, qName, attributesImpl, serializationContext);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    private void setAttributeProperty(Object object, QName qName, AttributesImpl attributesImpl, SerializationContext serializationContext) throws Exception {
        String string = serializationContext.getValueAsString(object, null);
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getLocalPart();
        attributesImpl.addAttribute(string2, string3, serializationContext.attributeQName2String(qName), "CDATA", string);
    }
}

