/*
 * Decompiled with CFR 0.152.
 */
package com.actional.axis;

import com.actional.APICredential;
import com.actional.APIFactory;
import com.actional.APISession;
import com.actional.BaseUtil;
import com.actional.CallContext;
import com.actional.axis.CallContextImpl;
import com.actional.axis.SdkWsdlGenerator;
import java.lang.reflect.Method;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.w3c.dom.Document;

public class AxisRPCProvider
extends RPCProvider {
    @Override
    protected Object makeNewServiceObject(MessageContext messageContext, String string) throws Exception {
        ClassLoader classLoader = messageContext.getClassLoader();
        ClassCache classCache = messageContext.getAxisEngine().getClassCache();
        JavaClass javaClass = classCache.lookup(string, classLoader);
        Class clazz = javaClass.getJavaClass();
        APICredential aPICredential = new APICredential(messageContext.getUsername(), messageContext.getPassword());
        APISession aPISession = APIFactory.sessionCreate((String)"axisserver://", (APICredential)aPICredential);
        return aPISession.create(clazz);
    }

    @Override
    protected Object invokeMethod(MessageContext messageContext, Method method, Object object, Object[] objectArray) throws Exception {
        String string = method.getName();
        Object[] objectArray2 = method.getParameterTypes();
        Method method2 = object.getClass().getDeclaredMethod(string, (Class<?>[])objectArray2);
        if (BaseUtil.length((Object[])objectArray2) > 0 && CallContext.class.isAssignableFrom((Class<?>)objectArray2[0])) {
            objectArray[0] = new CallContextImpl(messageContext);
        }
        return method2.invoke(object, objectArray);
    }

    @Override
    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        SOAPService sOAPService = messageContext.getService();
        ServiceDesc serviceDesc = sOAPService.getInitializedServiceDesc(messageContext);
        try {
            String string = messageContext.getStrProp(MessageContext.WSDLGEN_SERV_LOC_URL);
            if (string == null) {
                string = serviceDesc.getEndpointURL();
            }
            if (string == null) {
                string = messageContext.getStrProp(MessageContext.TRANS_URL);
            }
            Definition definition = WSDLFactory.newInstance().newDefinition();
            SdkWsdlGenerator.EmitterData emitterData = new SdkWsdlGenerator.EmitterData();
            SdkWsdlGenerator.addService(emitterData, messageContext.getAxisEngine(), definition, serviceDesc, string, messageContext.getTypeMappingRegistry());
            Document document = SdkWsdlGenerator.generateDocument(emitterData, definition);
            messageContext.setProperty("WSDL", document);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new AxisFault(noClassDefFoundError.toString(), noClassDefFoundError);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
    }
}

