/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaBeanHelperWriter
extends JavaClassWriter {
    static final String DEFAULT_BEAN_SERIALIZER = System.getProperty("org.apache.axis.wsdl.toJava.JavaClassWriter.defaultBeanSerializer", "com.actional.axis.BeanSerializer");
    protected TypeEntry type;
    protected Vector elements;
    protected Vector attributes;
    protected TypeEntry extendType;
    protected PrintWriter wrapperPW = null;
    protected Vector elementMetaData = null;

    protected JavaBeanHelperWriter(Emitter emitter, TypeEntry typeEntry, Vector vector, TypeEntry typeEntry2, Vector vector2) {
        super(emitter, typeEntry.getName() + "_Helper", "helper");
        this.type = typeEntry;
        this.elements = vector;
        this.attributes = vector2;
        this.extendType = typeEntry2;
    }

    protected void setPrintWriter(PrintWriter printWriter) {
        this.wrapperPW = printWriter;
    }

    @Override
    protected PrintWriter getPrintWriter(String string) throws IOException {
        return this.wrapperPW == null ? super.getPrintWriter(string) : this.wrapperPW;
    }

    @Override
    protected void registerFile(String string) {
        if (this.wrapperPW == null) {
            super.registerFile(string);
        }
    }

    @Override
    protected String verboseMessage(String string) {
        if (this.wrapperPW == null) {
            return super.verboseMessage(string);
        }
        return null;
    }

    @Override
    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileHeader(printWriter);
        }
    }

    @Override
    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeMetaData(printWriter);
        this.writeSerializer(printWriter);
        this.writeDeserializer(printWriter);
    }

    @Override
    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileFooter(printWriter);
        }
    }

    @Override
    protected void closePrintWriter(PrintWriter printWriter) {
        if (this.wrapperPW == null) {
            printWriter.close();
        }
    }

    protected void writeMetaData(PrintWriter printWriter) throws IOException {
        int n;
        if (this.elements != null) {
            for (n = 0; n < this.elements.size(); ++n) {
                ElementDecl elementDecl = (ElementDecl)this.elements.get(n);
                if (this.elementMetaData == null) {
                    this.elementMetaData = new Vector();
                }
                this.elementMetaData.add(elementDecl);
            }
        }
        printWriter.println("    // " + Messages.getMessage("typeMeta"));
        printWriter.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
        printWriter.println("        new org.apache.axis.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
        printWriter.println();
        if (this.attributes != null || this.elementMetaData != null) {
            QName qName;
            Object object;
            String string;
            Object object2;
            Object object3;
            n = 0;
            printWriter.println("    static {");
            if (this.attributes != null) {
                for (int i = 0; i < this.attributes.size(); i += 2) {
                    object3 = (TypeEntry)this.attributes.get(i);
                    object2 = (QName)this.attributes.get(i + 1);
                    string = ((QName)object2).getLocalPart();
                    object = Utils.xmlNameToJava(string);
                    object = this.getAsFieldName((String)object);
                    qName = ((SymTabEntry)object3).getQName();
                    printWriter.print("        ");
                    if (n == 0) {
                        printWriter.print("org.apache.axis.description.FieldDesc ");
                        n = 1;
                    }
                    printWriter.println("field = new org.apache.axis.description.AttributeDesc();");
                    printWriter.println("        field.setFieldName(\"" + (String)object + "\");");
                    printWriter.println("        field.setXmlName(" + Utils.getNewQName((QName)object2) + ");");
                    if (qName != null) {
                        printWriter.println("        field.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(field);");
                }
            }
            if (this.elementMetaData != null) {
                for (int i = 0; i < this.elementMetaData.size(); ++i) {
                    object3 = (ElementDecl)this.elementMetaData.elementAt(i);
                    if (((ElementDecl)object3).getAnyElement()) continue;
                    object2 = ((ElementDecl)object3).getName().getLocalPart();
                    string = Utils.xmlNameToJava((String)object2);
                    string = this.getAsFieldName(string);
                    object = ((ElementDecl)object3).getName();
                    qName = ((ElementDecl)object3).getType().getQName();
                    if (qName != null && qName.getLocalPart().indexOf("[") > 0) {
                        qName = null;
                    }
                    printWriter.print("        ");
                    if (n == 0) {
                        printWriter.print("org.apache.axis.description.FieldDesc ");
                        n = 1;
                    }
                    printWriter.println("field = new org.apache.axis.description.ElementDesc();");
                    printWriter.println("        field.setFieldName(\"" + string + "\");");
                    printWriter.println("        field.setXmlName(" + Utils.getNewQName((QName)object) + ");");
                    if (qName != null) {
                        printWriter.println("        field.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    if (((ElementDecl)object3).getMinOccursIs0()) {
                        printWriter.println("        field.setMinOccursIs0(true);");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(field);");
                }
            }
            printWriter.println("    };");
            printWriter.println();
            printWriter.println("    /**");
            printWriter.println("     * " + Messages.getMessage("returnTypeMeta"));
            printWriter.println("     */");
            printWriter.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
            printWriter.println("        return typeDesc;");
            printWriter.println("    }");
            printWriter.println();
        }
    }

    private String getAsFieldName(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return Utils.capitalizeFirstChar(string);
        }
        return string;
    }

    protected void writeSerializer(PrintWriter printWriter) throws IOException {
        String string = null;
        if (this.attributes != null || this.elementMetaData != null) {
            string = "typeDesc";
        }
        String string2 = DEFAULT_BEAN_SERIALIZER;
        if (this.type.isSimpleType()) {
            string2 = " org.apache.axis.encoding.ser.SimpleSerializer";
        }
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Serializer");
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.encoding.Serializer getSerializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string2 + "(");
        printWriter.println("            _javaType, _xmlType, " + string + ");");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeDeserializer(PrintWriter printWriter) throws IOException {
        String string = null;
        if (this.attributes != null || this.elementMetaData != null) {
            string = "typeDesc";
        }
        String string2 = " org.apache.axis.encoding.ser.BeanDeserializer";
        if (this.type.isSimpleType()) {
            string2 = " org.apache.axis.encoding.ser.SimpleDeserializer";
        }
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Deserializer");
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.encoding.Deserializer getDeserializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string2 + "(");
        printWriter.println("            _javaType, _xmlType, " + string + ");");
        printWriter.println("    }");
        printWriter.println();
    }
}

