/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Document;

public class Emitter {
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    public static final int MODE_RPC = 0;
    public static final int MODE_DOCUMENT = 1;
    public static final int MODE_DOC_WRAPPED = 2;
    private Class cls;
    private Class implCls;
    private Vector allowedMethods = null;
    private Vector disallowedMethods = null;
    private ArrayList stopClasses = new ArrayList();
    private boolean useInheritedMethods = false;
    private String intfNS;
    private String implNS;
    private String inputWSDL;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private String targetService = null;
    private String description;
    private int mode = 0;
    private TypeMapping tm = null;
    private TypeMapping defaultTM = null;
    public Namespaces namespaces = new Namespaces();
    public Map exceptionMsg = new HashMap();
    private ArrayList encodingList;
    public Types types;
    private String clsName;
    private String portTypeName;
    private String bindingName;
    private ServiceDesc serviceDesc;
    private ServiceDesc serviceDesc2;
    private String soapAction = "DEFAULT";

    public void emit(String string, String string2) throws IOException, WSDLException {
        Definition definition = this.getIntfWSDL();
        Definition definition2 = this.getImplWSDL();
        if (string == null) {
            string = this.getServicePortName() + "_interface.wsdl";
        }
        if (string2 == null) {
            string2 = this.getServicePortName() + "_implementation.wsdl";
        }
        Document document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
        this.types.insertTypesFragment(document);
        this.prettyDocumentToFile(document, string);
        document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition2);
        this.prettyDocumentToFile(document, string2);
    }

    public void emit(String string) throws IOException, WSDLException {
        this.emit(string, 0);
    }

    public Document emit(int n) throws IOException, WSDLException {
        Document document = null;
        Definition definition = null;
        switch (n) {
            case 0: {
                definition = this.getWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 1: {
                definition = this.getIntfWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 2: {
                definition = this.getImplWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
            }
        }
        return document;
    }

    public String emitToString(int n) throws IOException, WSDLException {
        Document document = this.emit(n);
        StringWriter stringWriter = new StringWriter();
        XMLUtils.PrettyDocumentToWriter(document, stringWriter);
        return stringWriter.toString();
    }

    public void emit(String string, int n) throws IOException, WSDLException {
        Document document = this.emit(n);
        if (string == null) {
            string = this.getServicePortName();
            switch (n) {
                case 0: {
                    string = string + ".wsdl";
                    break;
                }
                case 1: {
                    string = string + "_interface.wsdl";
                    break;
                }
                case 2: {
                    string = string + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(document, string);
    }

    public Definition getWSDL() throws IOException, WSDLException {
        this.init(0);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = this.createTypes(definition);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        this.writeService(definition, binding);
        return definition;
    }

    public Definition getIntfWSDL() throws IOException, WSDLException {
        this.init(1);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = this.createTypes(definition);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        return definition;
    }

    public Definition getImplWSDL() throws IOException, WSDLException {
        this.init(2);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.implNS);
        this.writeImport(definition, this.intfNS, this.importUrl);
        Binding binding = this.writeBinding(definition, false);
        this.writeService(definition, binding);
        return definition;
    }

    public void init(int n) {
        if (this.defaultTM == null) {
            this.defaultTM = DefaultTypeMappingImpl.getSingleton();
        }
        if (this.serviceDesc == null) {
            this.serviceDesc = new ServiceDesc();
            this.serviceDesc.setImplClass(this.cls);
            if (this.tm != null) {
                this.serviceDesc.setTypeMapping(this.tm);
            } else {
                this.serviceDesc.setTypeMapping(this.defaultTM);
            }
            this.serviceDesc.setStopClasses(this.stopClasses);
            this.serviceDesc.setAllowedMethods(this.allowedMethods);
            this.serviceDesc.setDisallowedMethods(this.disallowedMethods);
            if (this.implCls != null && this.implCls != this.cls && this.serviceDesc2 == null) {
                this.serviceDesc2 = new ServiceDesc();
                this.serviceDesc2.setImplClass(this.implCls);
                if (this.tm != null) {
                    this.serviceDesc2.setTypeMapping(this.tm);
                } else {
                    this.serviceDesc2.setTypeMapping(this.defaultTM);
                }
                this.serviceDesc2.setStopClasses(this.stopClasses);
                this.serviceDesc2.setAllowedMethods(this.allowedMethods);
                this.serviceDesc2.setDisallowedMethods(this.disallowedMethods);
            }
        }
        if (this.encodingList == null) {
            Object object;
            this.clsName = this.cls.getName();
            this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                object = this.getLocationUrl();
                if (object != null && (object = ((String)object).lastIndexOf(47) > 0 ? ((String)object).substring(((String)object).lastIndexOf(47) + 1) : (((String)object).lastIndexOf(92) > 0 ? ((String)object).substring(((String)object).lastIndexOf(92) + 1) : null)) != null && ((String)object).endsWith(".jws")) {
                    object = ((String)object).substring(0, ((String)object).length() - ".jws".length());
                }
                if (object == null || "".equals(object)) {
                    object = this.clsName;
                }
                this.setServicePortName((String)object);
            }
            if (this.getBindingName() == null) {
                this.setBindingName(this.getServicePortName() + "SoapBinding");
            }
            this.encodingList = new ArrayList();
            this.encodingList.add(Constants.URI_DEFAULT_SOAP_ENC);
            if (this.intfNS == null) {
                object = this.cls.getPackage();
                this.intfNS = this.namespaces.getCreate(object == null ? null : ((Package)object).getName());
            }
            if (this.implNS == null) {
                this.implNS = n == 0 ? this.intfNS : this.intfNS + "-impl";
            }
            this.namespaces.put(this.cls.getName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
    }

    private Definition createDefinition() throws WSDLException {
        Definition definition;
        if (this.inputWSDL == null) {
            definition = WSDLFactory.newInstance().newDefinition();
        } else {
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            Document document = XMLUtils.newDocument(this.inputWSDL);
            definition = wSDLReader.readWSDL(null, document);
            definition.setTypes(null);
        }
        return definition;
    }

    public Types createTypes(Definition definition) throws IOException, WSDLException {
        this.types = new Types(definition, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses);
        if (this.inputWSDL != null) {
            this.types.loadInputTypes(this.inputWSDL);
        }
        return this.types;
    }

    public void writeDefinitions(Definition definition, String string) {
        definition.setTargetNamespace(string);
        definition.addNamespace("intf", this.intfNS);
        definition.addNamespace("impl", this.implNS);
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        definition.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
        this.namespaces.putPrefix(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        definition.addNamespace("apachesoap", "http://xml.apache.org/xml-soap");
        this.namespaces.putPrefix("http://xml.apache.org/xml-soap", "apachesoap");
    }

    private void writeImport(Definition definition, String string, String string2) {
        Import import_ = definition.createImport();
        import_.setNamespaceURI(string);
        if (string2 != null && !"".equals(string2)) {
            import_.setLocationURI(string2);
        }
        definition.addImport(import_);
    }

    public Binding writeBinding(Definition definition, boolean bl) {
        QName qName = new QName(this.intfNS, this.getBindingName());
        Binding binding = definition.getBinding(qName);
        if (binding != null) {
            return binding;
        }
        binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(qName);
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        String string = this.mode == 0 ? "rpc" : "document";
        sOAPBindingImpl.setStyle(string);
        sOAPBindingImpl.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)sOAPBindingImpl);
        if (bl) {
            definition.addBinding(binding);
        }
        return binding;
    }

    public void writeService(Definition definition, Binding binding) {
        QName qName = new QName(this.implNS, this.getServiceElementName());
        Service service = definition.getService(qName);
        if (service == null) {
            service = definition.createService();
            service.setQName(qName);
            definition.addService(service);
        }
        Port port = definition.createPort();
        port.setBinding(binding);
        port.setName(this.getServicePortName());
        SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
        sOAPAddressImpl.setLocationURI(this.locationUrl);
        port.addExtensibilityElement((ExtensibilityElement)sOAPAddressImpl);
        service.addPort(port);
    }

    public void writePortType(Definition definition, Binding binding) throws WSDLException, AxisFault {
        QName qName = new QName(this.intfNS, this.getPortTypeName());
        PortType portType = definition.getPortType(qName);
        boolean bl = false;
        if (portType == null) {
            portType = definition.createPortType();
            portType.setUndefined(false);
            portType.setQName(qName);
            bl = true;
        } else if (!binding.getBindingOperations().isEmpty()) {
            return;
        }
        ArrayList arrayList = this.serviceDesc.getOperations();
        for (OperationDesc operationDesc : arrayList) {
            BindingOperation bindingOperation = this.writeOperation(definition, binding, operationDesc);
            Operation operation = bindingOperation.getOperation();
            OperationDesc operationDesc2 = operationDesc;
            if (this.serviceDesc2 != null) {
                OperationDesc[] operationDescArray = this.serviceDesc2.getOperationsByName(operationDesc.getName());
                boolean bl2 = false;
                if (operationDescArray != null) {
                    for (int i = 0; i < operationDescArray.length && !bl2; ++i) {
                        OperationDesc operationDesc3 = operationDescArray[i];
                        if (operationDesc3.getParameters().size() != operationDesc.getParameters().size()) continue;
                        boolean bl3 = true;
                        for (int j = 0; j < operationDesc.getParameters().size() && bl3; ++j) {
                            if (operationDesc3.getParameter(j).getMode() == operationDesc.getParameter(j).getMode() && operationDesc3.getParameter(j).getJavaType().equals(operationDesc.getParameter(j).getJavaType())) continue;
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        operationDesc2 = operationDesc3;
                        bl2 = true;
                    }
                }
            }
            this.writeMessages(definition, operation, operationDesc2, bindingOperation);
            if (!bl) continue;
            portType.addOperation(operation);
        }
        if (bl) {
            definition.addPortType(portType);
        }
        binding.setPortType(portType);
    }

    public void writeMessages(Definition definition, Operation operation, OperationDesc operationDesc, BindingOperation bindingOperation) throws WSDLException, AxisFault {
        Object object;
        Object object2;
        Object object3;
        Message message;
        Message message2;
        boolean bl = operation.getStyle() != OperationType.SOLICIT_RESPONSE;
        Input input = definition.createInput();
        if (bl) {
            message2 = this.writeRequestMessage(definition, operationDesc);
            message = this.writeResponseMessage(definition, operationDesc);
        } else {
            message2 = this.writeResponseMessage(definition, operationDesc);
            message = this.writeRequestMessage(definition, operationDesc);
            object3 = message2.getQName();
            message2.setQName(message.getQName());
            message.setQName((QName)object3);
        }
        input.setMessage(message2);
        object3 = message2.getQName().getLocalPart();
        input.setName((String)object3);
        bindingOperation.getBindingInput().setName((String)object3);
        operation.setInput(input);
        definition.addMessage(message2);
        Output output = definition.createOutput();
        output.setMessage(message);
        object3 = message.getQName().getLocalPart();
        output.setName((String)object3);
        bindingOperation.getBindingOutput().setName((String)object3);
        operation.setOutput(output);
        definition.addMessage(message);
        ArrayList arrayList = operationDesc.getFaults();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            object2 = (FaultDesc)arrayList.get(i);
            Message message3 = this.writeFaultMessage(definition, (FaultDesc)object2, operationDesc);
            object = definition.createFault();
            object.setMessage(message3);
            object.setName(((FaultDesc)object2).getName());
            operation.addFault((Fault)object);
            if (definition.getMessage(message3.getQName()) != null) continue;
            definition.addMessage(message3);
        }
        ArrayList arrayList2 = operationDesc.getParameters();
        object2 = new Vector();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (ParameterDesc)arrayList2.get(i);
            if (ClassUtils.callContextClass().isAssignableFrom(((ParameterDesc)object).getJavaType())) continue;
            ((Vector)object2).add(((ParameterDesc)object).getName());
        }
        if (!((Vector)object2).isEmpty()) {
            if (this.mode == 2) {
                ((Vector)object2).clear();
            }
            operation.setParameterOrdering((List)object2);
        }
    }

    public BindingOperation writeOperation(Definition definition, Binding binding, OperationDesc operationDesc) {
        Operation operation = definition.createOperation();
        operation.setName(operationDesc.getName());
        operation.setUndefined(false);
        return this.writeBindingOperation(definition, binding, operation, operationDesc);
    }

    private BindingOperation writeBindingOperation(Definition definition, Binding binding, Operation operation, OperationDesc operationDesc) {
        BindingOperation bindingOperation = definition.createBindingOperation();
        BindingInput bindingInput = definition.createBindingInput();
        BindingOutput bindingOutput = definition.createBindingOutput();
        bindingOperation.setName(operation.getName());
        bindingOperation.setOperation(operation);
        SOAPOperationImpl sOAPOperationImpl = new SOAPOperationImpl();
        String string = "";
        if ("OPERATION".equals(this.getSoapAction())) {
            string = operation.getName();
        } else if ("NONE".equals(this.getSoapAction())) {
            string = "";
        } else {
            string = operationDesc.getSoapAction();
            if (string == null) {
                string = "";
            }
        }
        sOAPOperationImpl.setSoapActionURI(string);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)sOAPOperationImpl);
        QName qName = operationDesc.getElementQName();
        String string2 = qName == null ? null : qName.getNamespaceURI();
        ExtensibilityElement extensibilityElement = null;
        extensibilityElement = this.writeSOAPBody(string2);
        bindingInput.addExtensibilityElement(extensibilityElement);
        ExtensibilityElement extensibilityElement2 = null;
        extensibilityElement2 = this.writeSOAPBody(string2);
        bindingOutput.addExtensibilityElement(extensibilityElement2);
        bindingOperation.setBindingInput(bindingInput);
        bindingOperation.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOperation);
        return bindingOperation;
    }

    private ExtensibilityElement writeSOAPBody(String string) {
        SOAPBodyImpl sOAPBodyImpl = new SOAPBodyImpl();
        if (this.mode == 0) {
            sOAPBodyImpl.setUse("encoded");
            sOAPBodyImpl.setEncodingStyles((List)this.encodingList);
            if (string == null) {
                if (this.targetService == null) {
                    sOAPBodyImpl.setNamespaceURI(this.intfNS);
                } else {
                    sOAPBodyImpl.setNamespaceURI(this.targetService);
                }
            } else {
                sOAPBodyImpl.setNamespaceURI(string);
            }
        } else {
            sOAPBodyImpl.setUse("literal");
        }
        return sOAPBodyImpl;
    }

    private Message writeRequestMessage(Definition definition, OperationDesc operationDesc) throws WSDLException, AxisFault {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Request");
        String string = operationDesc.getName();
        message.setQName(qName);
        message.setUndefined(false);
        if (this.createWrapper(definition, operationDesc, message, true, string)) {
            ArrayList arrayList = operationDesc.getParameters();
            for (int i = 0; i < arrayList.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                this.writePartToMessage(definition, message, true, parameterDesc, operationDesc, string);
            }
        }
        return message;
    }

    private Message writeResponseMessage(Definition definition, OperationDesc operationDesc) throws WSDLException, AxisFault {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Response");
        String string = operationDesc.getName() + "Response";
        message.setQName(qName);
        message.setUndefined(false);
        if (this.createWrapper(definition, operationDesc, message, false, string)) {
            ParameterDesc parameterDesc = new ParameterDesc();
            if (operationDesc.getReturnQName() == null) {
                parameterDesc.setName("return");
            } else {
                parameterDesc.setQName(operationDesc.getReturnQName());
            }
            parameterDesc.setTypeQName(operationDesc.getReturnType());
            parameterDesc.setMode((byte)2);
            parameterDesc.setIsReturn(true);
            parameterDesc.setJavaType(operationDesc.getReturnClass());
            this.writePartToMessage(definition, message, false, parameterDesc, operationDesc, string);
            ArrayList arrayList = operationDesc.getParameters();
            for (ParameterDesc parameterDesc2 : arrayList) {
                this.writePartToMessage(definition, message, false, parameterDesc2, operationDesc, string);
            }
        }
        return message;
    }

    private Message writeFaultMessage(Definition definition, FaultDesc faultDesc, OperationDesc operationDesc) throws WSDLException, AxisFault {
        String string = faultDesc.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        faultDesc.setName(string2);
        Message message = (Message)this.exceptionMsg.get(string);
        if (message == null) {
            message = definition.createMessage();
            QName qName = this.createMessageName(definition, string2, "");
            message.setQName(qName);
            message.setUndefined(false);
            if (this.createWrapper(definition, operationDesc, message, true, string2)) {
                ArrayList arrayList = faultDesc.getParameters();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                    this.writePartToMessage(definition, message, true, parameterDesc, operationDesc, string2);
                }
            }
            this.exceptionMsg.put(string, message);
        }
        return message;
    }

    public String writePartToMessage(Definition definition, Message message, boolean bl, ParameterDesc parameterDesc, OperationDesc operationDesc, String string) throws WSDLException, AxisFault {
        if (parameterDesc == null || ClassUtils.callContextClass().isAssignableFrom(parameterDesc.getJavaType()) || parameterDesc.getJavaType() == Void.TYPE) {
            return null;
        }
        if (bl && parameterDesc.getMode() == 2) {
            return null;
        }
        if (!bl && parameterDesc.getMode() == 1) {
            return null;
        }
        Class clazz = parameterDesc.getJavaType();
        if (parameterDesc.getMode() != 1 && !parameterDesc.getIsReturn()) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        switch (this.mode) {
            case 0: {
                QName qName = this.types.writeTypeForPart(clazz, parameterDesc.getTypeQName());
                this.types.writeElementForPart(clazz, parameterDesc.getTypeQName());
                if (qName == null) break;
                Part part = definition.createPart();
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
                break;
            }
            case 1: {
                QName qName = this.types.writeTypeForPart(clazz, parameterDesc.getTypeQName());
                QName qName2 = this.types.writeElementForPart(clazz, parameterDesc.getTypeQName());
                if (qName2 != null) {
                    Part part = definition.createPart();
                    part.setName(parameterDesc.getName());
                    part.setElementName(qName2);
                    message.addPart(part);
                    break;
                }
                if (qName == null) break;
                Part part = definition.createPart();
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
                break;
            }
            case 2: {
                QName qName = this.types.writeTypeForPart(clazz, parameterDesc.getTypeQName());
                if (qName == null) break;
                QName qName3 = this.getWrapperQName(definition, operationDesc, message, bl, string);
                this.types.writeWrapperForPart(qName3, parameterDesc.getName(), qName, this.types.isNullable(clazz));
                break;
            }
        }
        return parameterDesc.getName();
    }

    private boolean createWrapper(Definition definition, OperationDesc operationDesc, Message message, boolean bl, String string) {
        if (2 != this.mode) {
            return true;
        }
        QName qName = this.getWrapperQName(definition, operationDesc, message, bl, string);
        Part part = definition.createPart();
        part.setName("parameters");
        part.setElementName(qName);
        message.addPart(part);
        if (this.types.wrapperExists(qName)) {
            return false;
        }
        this.types.writeWrapper(qName);
        return true;
    }

    private QName getWrapperQName(Definition definition, OperationDesc operationDesc, Message message, boolean bl, String string) {
        String string2;
        Object object;
        QName qName = operationDesc.getElementQName();
        if (bl) {
            object = message.getQName();
            string2 = ((QName)object).getLocalPart();
            if (qName == null) {
                qName = new QName(((QName)object).getNamespaceURI(), string2.substring(0, string2.indexOf("Request")));
            } else if (string2.indexOf("Request") < 0) {
                qName = new QName(qName.getNamespaceURI(), string2);
            }
        } else {
            qName = qName == null ? message.getQName() : new QName(qName.getNamespaceURI(), message.getQName().getLocalPart());
        }
        if (2 == this.mode) {
            qName = new QName(qName.getNamespaceURI(), string);
        }
        object = definition.getNamespaces();
        string2 = qName.getNamespaceURI();
        if (object == null) {
            definition.addNamespace("ns0", string2);
        } else {
            String string3 = "ns0";
            if (object.containsValue(string2)) {
                Iterator iterator;
                Set set = object.entrySet();
                Iterator iterator2 = iterator = set == null ? null : set.iterator();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!string2.equals(entry.getValue())) continue;
                        string3 = (String)entry.getKey();
                        break;
                    }
                }
            } else {
                int n = 0;
                while (object.containsKey(string3 = "ns" + Integer.toString(n++))) {
                }
            }
            definition.addNamespace(string3, string2);
        }
        return qName;
    }

    private QName createMessageName(Definition definition, String string, String string2) {
        QName qName = new QName(this.intfNS, string.concat(string2));
        int n = 1;
        while (definition.getMessage(qName) != null) {
            StringBuilder stringBuilder = new StringBuilder(string.concat(string2));
            stringBuilder.append(n);
            qName = new QName(this.intfNS, stringBuilder.toString());
            ++n;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document document, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
        XMLUtils.PrettyDocumentToStream(document, fileOutputStream);
        fileOutputStream.close();
    }

    public Class getCls() {
        return this.cls;
    }

    public void setCls(Class clazz) {
        this.cls = clazz;
    }

    public void setClsSmart(Class clazz, String string) {
        if (clazz == null || string == null) {
            return;
        }
        if (string.lastIndexOf(47) > 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        } else if (string.lastIndexOf(92) > 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Class<?> clazz2 = null;
        for (int i = 0; i < constructorArray.length && clazz2 == null; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || !classArray[0].isInterface() || classArray[0].getName() == null || !Types.getLocalNameFromFullName(classArray[0].getName()).equals(string)) continue;
            clazz2 = classArray[0];
        }
        if (clazz2 != null) {
            this.setCls(clazz2);
            if (this.implCls == null) {
                this.setImplCls(clazz);
            }
        } else {
            this.setCls(clazz);
        }
    }

    public void setCls(String string) throws ClassNotFoundException {
        this.cls = ClassUtils.forName(string);
    }

    public Class getImplCls() {
        return this.implCls;
    }

    public void setImplCls(Class clazz) {
        this.implCls = clazz;
    }

    public void setImplCls(String string) {
        try {
            this.implCls = ClassUtils.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String string) {
        this.intfNS = string;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String string) {
        this.implNS = string;
    }

    public Vector getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.allowedMethods == null) {
                this.allowedMethods = new Vector();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.allowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public void setAllowedMethods(Vector vector) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new Vector();
        }
        this.allowedMethods.addAll(vector);
    }

    public boolean getUseInheritedMethods() {
        return this.useInheritedMethods;
    }

    public void setUseInheritedMethods(boolean bl) {
        this.useInheritedMethods = bl;
    }

    public void setDisallowedMethods(Vector vector) {
        if (this.disallowedMethods == null) {
            this.disallowedMethods = new Vector();
        }
        this.disallowedMethods.addAll(vector);
    }

    public void setDisallowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.disallowedMethods == null) {
                this.disallowedMethods = new Vector();
            }
            this.disallowedMethods = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.disallowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setStopClasses(ArrayList arrayList) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(arrayList);
    }

    public void setStopClasses(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.stopClasses.add(stringTokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String string) {
        this.inputWSDL = string;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String string) {
        this.locationUrl = string;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String string) {
        this.importUrl = string;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String string) {
        this.servicePortName = string;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String string) {
        this.serviceElementName = string;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String string) {
        this.bindingName = string;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String string) {
        this.targetService = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public void setDefaultTypeMapping(TypeMapping typeMapping) {
        this.defaultTM = typeMapping;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public ServiceDesc getServiceDesc() {
        return this.serviceDesc;
    }

    public void setServiceDesc(ServiceDesc serviceDesc) {
        this.serviceDesc = serviceDesc;
    }
}

