/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.enum.Style;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.bytecode.ParamNameExtractor;
import org.apache.axis.wsdl.Skeleton;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceDesc {
    protected static Log log = LogFactory.getLog(ServiceDesc.class.getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Style style = Style.RPC;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private boolean isSkeletonClass = false;
    private Method skelMethod = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private HashMap method2ParamsMap = new HashMap();
    private OperationDesc messageServiceDefaultOp = null;
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = DefaultTypeMappingImpl.getSingleton();
    private TypeMappingRegistry tmr = null;
    private boolean haveAllSkeletonMethods = false;
    private boolean introspectionComplete = false;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isWrapped() {
        return this.style == Style.RPC || this.style == Style.WRAPPED;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String string) {
        this.wsdlFileName = string;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List list) {
        this.allowedMethods = list;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class clazz) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = clazz;
        if (Skeleton.class.isAssignableFrom(clazz)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
    }

    private void loadSkeletonOperations() {
        Method method = null;
        try {
            method = this.implClass.getDeclaredMethod("getOperationDescs", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method == null) {
            return;
        }
        try {
            Collection collection = (Collection)method.invoke((Object)this.implClass, null);
            for (OperationDesc operationDesc : collection) {
                this.addOperationDesc(operationDesc);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        this.haveAllSkeletonMethods = true;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList arrayList) {
        this.stopClasses = arrayList;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List list) {
        this.disallowedMethods = list;
    }

    public void addOperationDesc(OperationDesc operationDesc) {
        String string;
        ArrayList<OperationDesc> arrayList;
        this.operations.add(operationDesc);
        operationDesc.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((arrayList = (ArrayList<OperationDesc>)this.name2OperationsMap.get(string = operationDesc.getName())) == null) {
            arrayList = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(string, arrayList);
        }
        arrayList.add(operationDesc);
    }

    public ArrayList getOperations() {
        this.loadServiceDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        OperationDesc[] operationDescArray = new OperationDesc[arrayList.size()];
        return arrayList.toArray(operationDescArray);
    }

    public OperationDesc getOperationByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return (OperationDesc)arrayList.get(0);
    }

    public OperationDesc getOperationByElementQName(QName qName) {
        OperationDesc[] operationDescArray = this.getOperationsByQName(qName);
        if (operationDescArray != null && operationDescArray.length > 0) {
            return operationDescArray[0];
        }
        return null;
    }

    public OperationDesc[] getOperationsByQName(QName qName) {
        this.initQNameMap();
        ArrayList arrayList = (ArrayList)this.qname2OperationsMap.get(qName);
        if (arrayList == null) {
            if ((this.style == Style.RPC || this.style == Style.MESSAGE && this.getDefaultNamespace() == null) && this.name2OperationsMap != null) {
                arrayList = (ArrayList)this.name2OperationsMap.get(qName.getLocalPart());
            }
            if (this.style == Style.MESSAGE && this.messageServiceDefaultOp != null) {
                return new OperationDesc[]{this.messageServiceDefaultOp};
            }
            if (arrayList == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)arrayList.get(0)).getName());
        OperationDesc[] operationDescArray = arrayList.toArray(new OperationDesc[arrayList.size()]);
        Arrays.sort(operationDescArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Method method = ((OperationDesc)object).getMethod();
                Method method2 = ((OperationDesc)object2).getMethod();
                return method.getParameterTypes().length - method2.getParameterTypes().length;
            }
        });
        return operationDescArray;
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadServiceDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            for (OperationDesc operationDesc : this.operations) {
                ArrayList<OperationDesc> arrayList = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (arrayList == null) {
                    arrayList = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), arrayList);
                }
                arrayList.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc operationDesc, Class clazz) {
        Object object;
        if (operationDesc.getMethod() != null) {
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            Class<?>[] classArray;
            object = methodArray[i];
            if (!Modifier.isPublic(((Method)object).getModifiers()) || !((Method)object).getName().equals(operationDesc.getName())) continue;
            if (this.style == Style.MESSAGE) {
                int n2 = this.checkMessageMethod((Method)object);
                if (n2 == -4) continue;
                if (n2 == -1) {
                    throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
                }
                operationDesc.setMessageOperationStyle(n2);
            }
            if ((classArray = ((Method)object).getParameterTypes()).length != operationDesc.getNumParams()) continue;
            for (n = 0; n < classArray.length; ++n) {
                ParameterDesc parameterDesc;
                QName qName;
                Class clazz2;
                Class clazz3 = clazz2 = classArray[n];
                if (Holder.class.isAssignableFrom(clazz2)) {
                    clazz3 = JavaUtils.getHolderValueType(clazz2);
                }
                if ((qName = (parameterDesc = operationDesc.getParameter(n)).getTypeQName()) == null) {
                    qName = this.tm.getTypeQName(clazz3);
                    parameterDesc.setTypeQName(qName);
                } else {
                    Class clazz4 = parameterDesc.getJavaType();
                    if (clazz4 != null && JavaUtils.getHolderValueType(clazz4) != null) {
                        clazz4 = JavaUtils.getHolderValueType(clazz4);
                    }
                    if (clazz4 == null) {
                        clazz4 = this.tm.getClassForQName(parameterDesc.getTypeQName());
                    }
                    if (!JavaUtils.isConvertable(clazz4, clazz3)) break;
                }
                parameterDesc.setJavaType(clazz2);
            }
            if (n != classArray.length) continue;
            operationDesc.setReturnClass(((Method)object).getReturnType());
            operationDesc.setMethod((Method)object);
            this.method2OperationMap.put(object, operationDesc);
            return;
        }
        Class clazz5 = clazz.getSuperclass();
        if (!(clazz5 == null || clazz5.getName().startsWith("java.") || clazz5.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz5.getName()))) {
            this.syncOperationToClass(operationDesc, clazz5);
        }
        if (operationDesc.getMethod() == null) {
            object = new InternalException(Messages.getMessage("serviceDescOperSync00", operationDesc.getName(), clazz.getName()));
            throw object;
        }
    }

    private int checkMessageMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            if (classArray[0] == Element[].class && method.getReturnType() == Element[].class) {
                return 3;
            }
            if (classArray[0] == SOAPBodyElement[].class && method.getReturnType() == SOAPBodyElement[].class) {
                return 1;
            }
            if (classArray[0] == Document.class && method.getReturnType() == Document.class) {
                return 4;
            }
        } else if (classArray.length == 2 && classArray[0] == SOAPEnvelope.class && classArray[1] == SOAPEnvelope.class && method.getReturnType() == Void.TYPE) {
            return 2;
        }
        if (null != this.allowedMethods && !this.allowedMethods.isEmpty()) {
            throw new InternalException(Messages.getMessage("badMsgMethodParams", method.getName()));
        }
        return -4;
    }

    public void loadServiceDescByIntrospection() {
        this.loadServiceDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadServiceDescByIntrospection(Class clazz) {
        Iterator iterator;
        if (this.introspectionComplete || clazz == null) {
            return;
        }
        this.implClass = clazz;
        if (Skeleton.class.isAssignableFrom(clazz)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        AxisServiceConfig axisServiceConfig = null;
        try {
            iterator = clazz.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (iterator != null && Modifier.isStatic(((Method)((Object)iterator)).getModifiers())) {
                axisServiceConfig = (AxisServiceConfig)((Method)((Object)iterator)).invoke(null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (axisServiceConfig != null && (iterator = axisServiceConfig.getAllowedMethods()) != null && !"*".equals(iterator)) {
            Object object = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer((String)((Object)iterator), " ,");
            while (stringTokenizer.hasMoreTokens()) {
                ((ArrayList)object).add(stringTokenizer.nextToken());
            }
            this.setAllowedMethods((List)object);
        }
        this.loadServiceDescByIntrospectionRecursive(clazz);
        for (Object object : this.operations) {
            if (((OperationDesc)object).getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", ((OperationDesc)object).getName(), "" + ((OperationDesc)object).getNumParams()));
        }
        if (this.style == Style.MESSAGE && this.operations.size() == 1) {
            this.messageServiceDefaultOp = (OperationDesc)this.operations.get(0);
        }
        this.introspectionComplete = true;
    }

    private void loadServiceDescByIntrospectionRecursive(Class clazz) {
        if (Skeleton.class.equals((Object)clazz)) {
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isPublic(methodArray[i].getModifiers())) continue;
            this.getSyncedOperationsForName(clazz, methodArray[i].getName());
        }
        if (clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                if (this.stopClasses != null && this.stopClasses.contains(clazz2.getName())) continue;
                this.loadServiceDescByIntrospectionRecursive(clazz2);
            }
        } else {
            Class clazz3 = clazz.getSuperclass();
            if (!(clazz3 == null || clazz3.getName().startsWith("java.") || clazz3.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz3.getName()))) {
                this.loadServiceDescByIntrospectionRecursive(clazz3);
            }
        }
    }

    public void loadServiceDescByIntrospection(Class clazz, TypeMapping typeMapping) {
        this.implClass = clazz;
        this.tm = typeMapping;
        if (Skeleton.class.isAssignableFrom(this.implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        this.loadServiceDescByIntrospection();
    }

    private void getSyncedOperationsForName(Class clazz, String string) {
        List list;
        if (this.isSkeletonClass && (string.equals("getOperationDescByName") || string.equals("getOperationDescs"))) {
            return;
        }
        if (clazz == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(string)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(string)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(string)) {
            return;
        }
        if (this.isSkeletonClass && !this.haveAllSkeletonMethods) {
            if (this.skelMethod == null) {
                try {
                    this.skelMethod = clazz.getDeclaredMethod("getOperationDescByName", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (this.skelMethod == null) {
                    return;
                }
            }
            try {
                list = (List)this.skelMethod.invoke((Object)clazz, string);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.addOperationDesc((OperationDesc)iterator.next());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
        }
        if (this.name2OperationsMap != null && (list = (ArrayList)this.name2OperationsMap.get(string)) != null) {
            for (OperationDesc operationDesc : list) {
                if (operationDesc.getMethod() != null) continue;
                this.syncOperationToClass(operationDesc, clazz);
            }
        }
        this.createOperationsForName(clazz, string);
        this.completedNames.add(string);
    }

    private void createOperationsForName(Class clazz, String string) {
        if (this.isSkeletonClass && (string.equals("getOperationDescByName") || string.equals("getOperationDescs"))) {
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(string)) continue;
            this.createOperationForMethod(method);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.getName().startsWith("java.") && !clazz2.getName().startsWith("javax.")) {
            this.createOperationsForName(clazz2, string);
        }
    }

    private void createOperationForMethod(Method method) {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        int n;
        Object[] objectArray;
        GenericDeclaration genericDeclaration;
        Object object2;
        ArrayList arrayList;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        ArrayList arrayList2 = arrayList = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (arrayList != null && !arrayList.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (OperationDesc)arrayList.get(i);
                genericDeclaration = ((OperationDesc)object2).getMethod();
                if (genericDeclaration == null || classArray.length != (objectArray = genericDeclaration.getParameterTypes()).length) continue;
                for (n = 0; n < objectArray.length && objectArray[n].equals(classArray[n]); ++n) {
                }
                if (n != objectArray.length) continue;
                return;
            }
        }
        OperationDesc operationDesc = new OperationDesc();
        operationDesc.setName(method.getName());
        object2 = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            object2 = (String)this.namespaceMappings.get(0);
        }
        operationDesc.setElementQName(new QName((String)object2, method.getName()));
        operationDesc.setMethod(method);
        if (this.style == Style.MESSAGE) {
            int n2 = this.checkMessageMethod(method);
            if (n2 == -4) {
                return;
            }
            if (n2 == -1) {
                throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
            }
            operationDesc.setMessageOperationStyle(n2);
            operationDesc.setReturnClass(Object.class);
            operationDesc.setReturnType(Constants.XSD_ANYTYPE);
        } else {
            genericDeclaration = method.getReturnType();
            operationDesc.setReturnClass((Class)genericDeclaration);
            operationDesc.setReturnType(this.tm.getTypeQName(method.getReturnType()));
            objectArray = this.getParamNames(method);
            for (n = 0; n < classArray.length; ++n) {
                serializable2 = classArray[n];
                serializable = new ParameterDesc();
                if (objectArray != null && objectArray[n] != null && ((String)objectArray[n]).length() > 0) {
                    ((ParameterDesc)serializable).setName((String)objectArray[n]);
                } else {
                    ((ParameterDesc)serializable).setName("in" + n);
                }
                object = JavaUtils.getHolderValueType(serializable2);
                if (object != null) {
                    ((ParameterDesc)serializable).setMode((byte)3);
                    ((ParameterDesc)serializable).setTypeQName(this.tm.getTypeQName((Class)object));
                } else {
                    ((ParameterDesc)serializable).setMode((byte)1);
                    ((ParameterDesc)serializable).setTypeQName(this.tm.getTypeQName((Class)serializable2));
                }
                ((ParameterDesc)serializable).setJavaType((Class)serializable2);
                operationDesc.addParameter((ParameterDesc)serializable);
            }
        }
        Class[] classArray2 = new Class[method.getExceptionTypes().length];
        classArray2 = method.getExceptionTypes();
        for (int i = 0; i < classArray2.length; ++i) {
            Class clazz = classArray2[i];
            if (clazz == RemoteException.class || clazz == AxisFault.class || clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) continue;
            serializable2 = new ParameterDesc(new QName("", "fault"), 1, this.tm.getTypeQName(clazz));
            ((ParameterDesc)serializable2).setJavaType(clazz);
            serializable = new ArrayList();
            ((ArrayList)serializable).add(serializable2);
            object = clazz.getName();
            FaultDesc faultDesc = new FaultDesc();
            faultDesc.setName((String)object);
            faultDesc.setParameters((ArrayList)serializable);
            operationDesc.addFault(faultDesc);
        }
        this.addOperationDesc(operationDesc);
        this.method2OperationMap.put(method, operationDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] stringArray = (String[])this.method2ParamsMap.get(method);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, stringArray);
            return stringArray;
        }
    }

    public void setNamespaceMappings(List list) {
        this.namespaceMappings = list;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String string) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String string) {
        this.endpointURL = string;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.tmr = typeMappingRegistry;
    }
}

