/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import com.actional.axis.AxisServletHolder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.activation.DataSource;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ManagedMemoryDataSource
implements DataSource {
    private static final Log LOGGER = LogFactory.getLog(ManagedMemoryDataSource.class.getName());
    protected String contentType = "application/octet-stream";
    InputStream ss;
    public static final int READ_CHUNK_SZ = 32768;
    public static final int MAX_MEMORY_DISK_CACHED = -1;
    public static final int MAX_CACHED_DEFAULT = Integer.getInteger("org.apache.axis.attachments.ManagedMemoryDataSource.MaxCachedMemKB", 16) * 1024;
    protected int maxCached = MAX_CACHED_DEFAULT;
    protected File diskCacheFile;
    protected Map readers = new WeakHashMap();
    protected boolean deleted = false;
    protected boolean debugEnabled = false;
    protected List memorybuflist = new LinkedList();
    protected byte[] currentMemoryBuf;
    protected int currentMemoryBufSz = 0;
    protected int totalsz = 0;
    protected BufferedOutputStream cachediskstream;
    protected boolean closed;
    private static final Log INPUTSTREAM_LOGGER = LogFactory.getLog(Instream.class.getName());

    protected ManagedMemoryDataSource() {
    }

    public ManagedMemoryDataSource(InputStream inputStream, int n, String string) throws IOException {
        this(inputStream, n, string, false);
    }

    public ManagedMemoryDataSource(InputStream inputStream, int n, String string, boolean bl) throws IOException {
        this.ss = inputStream;
        this.maxCached = n;
        if (null != string && string.length() != 0) {
            this.contentType = string;
        }
        if (n < -1) {
            throw new IllegalArgumentException(Messages.getMessage("badMaxCached", "" + n));
        }
        if (LOGGER.isDebugEnabled()) {
            this.debugEnabled = true;
        }
        if (bl) {
            int n2;
            byte[] byArray = new byte[32768];
            do {
                if ((n2 = inputStream.read(byArray)) <= 0) continue;
                this.write(byArray, n2);
            } while (n2 > -1);
            this.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        return new Instream();
    }

    public String getName() {
        String string = null;
        try {
            this.flushToDisk();
            if (this.diskCacheFile != null) {
                string = this.diskCacheFile.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            this.diskCacheFile = null;
        }
        return string;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public synchronized int computeMemorySize() {
        int n = 0;
        if (this.memorybuflist != null) {
            for (byte[] byArray : this.memorybuflist) {
                if (byArray == null) continue;
                n += byArray.length;
            }
        }
        return n;
    }

    protected void write(byte[] byArray) throws IOException {
        this.write(byArray, byArray.length);
    }

    protected synchronized void write(byte[] byArray, int n) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        int n2 = n;
        if (null != this.memorybuflist && this.totalsz + n2 > this.maxCached && null == this.cachediskstream) {
            this.flushToDisk();
        }
        if (this.memorybuflist != null) {
            int n3 = 0;
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int n4 = Math.min(n2 - n3, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(byArray, n3, this.currentMemoryBuf, this.currentMemoryBufSz, n4);
                this.currentMemoryBufSz += n4;
                if ((n3 += n4) >= n2) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (n3 < n2);
        }
        if (null != this.cachediskstream) {
            this.cachediskstream.write(byArray, 0, n);
        }
        this.totalsz += n2;
    }

    protected synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
            if (null != this.memorybuflist) {
                if (this.currentMemoryBufSz > 0) {
                    byte[] byArray = new byte[this.currentMemoryBufSz];
                    System.arraycopy(this.currentMemoryBuf, 0, byArray, 0, this.currentMemoryBufSz);
                    this.memorybuflist.set(this.memorybuflist.size() - 1, byArray);
                }
                this.currentMemoryBuf = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void flushToDisk() throws IOException, FileNotFoundException {
        List list = this.memorybuflist;
        this.memorybuflist = null;
        LOGGER.debug((Object)Messages.getMessage("maxCached", "" + this.maxCached, "" + this.totalsz));
        if (list != null && null == this.cachediskstream) {
            try {
                Hashtable hashtable;
                String string;
                MessageContext messageContext = MessageContext.getCurrentContext();
                String string2 = string = messageContext == null ? null : messageContext.getStrProp(MessageContext.ATTACHMENTS_DIR);
                if (string == null && (hashtable = AxisServletHolder.getAxisServlet().getEngine().getOptions()) != null) {
                    string = (String)hashtable.get("attachments.Directory");
                }
                this.diskCacheFile = File.createTempFile("Axis", "axis", string == null ? null : new File(string));
                LOGGER.debug((Object)Messages.getMessage("diskCache", this.diskCacheFile.getAbsolutePath()));
                this.cachediskstream = new BufferedOutputStream(new FileOutputStream(this.diskCacheFile));
                int n = list.size();
                for (byte[] byArray : list) {
                    int n2 = n-- == 0 ? this.currentMemoryBufSz : byArray.length;
                    this.cachediskstream.write(byArray, 0, n2);
                    if (!this.closed) continue;
                    this.cachediskstream.close();
                    this.cachediskstream = null;
                }
                this.memorybuflist = null;
            }
            catch (SecurityException securityException) {
                this.diskCacheFile = null;
                this.cachediskstream = null;
                this.maxCached = Integer.MAX_VALUE;
                LOGGER.info((Object)Messages.getMessage("nodisk00"), (Throwable)securityException);
            }
        }
    }

    public synchronized boolean delete() {
        boolean bl = false;
        this.deleted = true;
        this.memorybuflist = null;
        if (this.diskCacheFile != null) {
            if (this.cachediskstream != null) {
                try {
                    this.cachediskstream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cachediskstream = null;
            }
            for (Instream instream : this.readers.keySet()) {
                if (null == instream) continue;
                try {
                    instream.close();
                }
                catch (Exception exception) {}
            }
            this.readers.clear();
            try {
                this.diskCacheFile.delete();
                bl = true;
            }
            catch (Exception exception) {
                this.diskCacheFile.deleteOnExit();
            }
        }
        return bl;
    }

    private class Instream
    extends InputStream {
        protected int bread = 0;
        FileInputStream fin;
        int currentIndex = 0;
        byte[] currentBuf;
        int currentBufPos = 0;
        boolean readClosed = false;

        protected Instream() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            ManagedMemoryDataSource.this.readers.put(this, null);
        }

        @Override
        public int available() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            int n = ManagedMemoryDataSource.this.totalsz - this.bread;
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)("available() = " + n + "."));
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                byte[] byArray = new byte[1];
                int n = this.read(byArray, 0, 1);
                if (n == -1) {
                    return -1;
                }
                return byArray[0];
            }
        }

        @Override
        public boolean markSupported() {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)"markSupported() = false.");
            }
            return false;
        }

        @Override
        public void mark(int n) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)"mark()");
            }
        }

        @Override
        public void reset() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)"reset()");
            }
            throw new IOException(Messages.getMessage("noResetMark"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)("skip(" + l + ")."));
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (l < 1L) {
                return 0L;
            }
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                l = Math.min(l, (long)(ManagedMemoryDataSource.this.totalsz - this.bread));
                if (l == 0L) {
                    return 0L;
                }
                List list = ManagedMemoryDataSource.this.memorybuflist;
                int n = 0;
                if (list != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])list.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        long l2 = Math.min((long)(this.currentBuf.length - this.currentBufPos), l - (long)n);
                        n = (int)((long)n + l2);
                        this.currentBufPos = (int)((long)this.currentBufPos + l2);
                        if ((long)n >= l) continue;
                        this.currentBuf = (byte[])list.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while ((long)n < l);
                }
                if (null != this.fin) {
                    this.fin.skip(l);
                }
                this.bread = (int)((long)this.bread + l);
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)("skipped " + l + "."));
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)(this.hashCode() + " read(" + n + ", " + n2 + ")"));
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (byArray == null) {
                throw new InternalException(Messages.getMessage("nullInput"));
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException(Messages.getMessage("negOffset", "" + n));
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException(Messages.getMessage("length", "" + n2));
            }
            if (n2 + n > byArray.length) {
                throw new IndexOutOfBoundsException(Messages.getMessage("writeBeyond"));
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                if (this.bread == ManagedMemoryDataSource.this.totalsz) {
                    return -1;
                }
                List list = ManagedMemoryDataSource.this.memorybuflist;
                n2 = Math.min(n2, ManagedMemoryDataSource.this.totalsz - this.bread);
                if (ManagedMemoryDataSource.this.debugEnabled) {
                    INPUTSTREAM_LOGGER.debug((Object)("len = " + n2));
                }
                if (list != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])list.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        int n4 = Math.min(this.currentBuf.length - this.currentBufPos, n2 - n3);
                        System.arraycopy(this.currentBuf, this.currentBufPos, byArray, n + n3, n4);
                        this.currentBufPos += n4;
                        if ((n3 += n4) >= n2) continue;
                        this.currentBuf = (byte[])list.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while (n3 < n2);
                }
                if (n3 == 0 && null != ManagedMemoryDataSource.this.diskCacheFile) {
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        INPUTSTREAM_LOGGER.debug((Object)Messages.getMessage("reading", "" + n2));
                    }
                    if (null == this.fin) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            INPUTSTREAM_LOGGER.debug((Object)Messages.getMessage("openBread", ManagedMemoryDataSource.this.diskCacheFile.getCanonicalPath()));
                            INPUTSTREAM_LOGGER.debug((Object)Messages.getMessage("openBread", "" + this.bread));
                        }
                        this.fin = new FileInputStream(ManagedMemoryDataSource.this.diskCacheFile);
                        if (this.bread > 0) {
                            this.fin.skip(this.bread);
                        }
                    }
                    if (ManagedMemoryDataSource.this.cachediskstream != null) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            INPUTSTREAM_LOGGER.debug((Object)Messages.getMessage("flushing"));
                        }
                        ManagedMemoryDataSource.this.cachediskstream.flush();
                    }
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        INPUTSTREAM_LOGGER.debug((Object)Messages.getMessage("flushing"));
                        INPUTSTREAM_LOGGER.debug((Object)("len=" + n2));
                        INPUTSTREAM_LOGGER.debug((Object)("off=" + n));
                        INPUTSTREAM_LOGGER.debug((Object)("b.length=" + byArray.length));
                    }
                    n3 = this.fin.read(byArray, n, n2);
                }
                if (n3 > 0) {
                    this.bread += n3;
                }
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)(this.hashCode() + Messages.getMessage("read", "" + n3)));
            }
            return n3;
        }

        @Override
        public synchronized void close() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                INPUTSTREAM_LOGGER.debug((Object)"close()");
            }
            if (!this.readClosed) {
                ManagedMemoryDataSource.this.readers.remove(this);
                this.readClosed = true;
                if (this.fin != null) {
                    this.fin.close();
                }
                this.fin = null;
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

